typedef enum {
   NONE,
   WFPC2,
   ACS,
   WFC3,
   ROMAN,
   NIRCAM,
   NIRISS,
   MIRI,
   NISP,
   VIS
} instrument;

typedef struct {
   instrument inst;
   int cm;
   int filt;
   int i1; // free field - used by WFPC2 for temperature
   int i2; // free field - used by WFPC2 for gain
   double data1; // free field - used by NIRCAM for conversion from DN/sec to Jy and NISP for AB ZP
   double data2; // free field - used by NISP for VEGA ZP
} hstmodetype;

typedef struct{float ct0,ct,dct,ctcorr,dctcorr,sky,m,dm,chi,sh,rnd,r,e,a,b,c,crowd;int flag;} photdatatype;

typedef double apsftype[3][6];
typedef float apskytype[2];
typedef float dpostype[40];
typedef float wcstype[80];
typedef double wcsreftype[4];
typedef int hstoffsettype[2];
typedef char fntype[161];

typedef struct {
   fntype base;
   dpostype dpos;
   dpostype ref2img;
   apsftype apsf;
   float apdata[3];
   double RAper,RChi,RSky0,RSky1,RSky20,RSky21;
   int RPSF;
} imgdatatype;

#ifdef DOLPHOT_MAIN
#define EXTERN
#else
#define EXTERN extern

// Used by camera packages to disable certain PSF features
extern void ZeroCameraPars(void);

// GLOBAL Variables allocated in alloc_img_data, used by camera packages
EXTERN int *RPSF,*rphot,*poffreset,*lastpsftype;
EXTERN double *iGAIN,*invGAIN,*iEXP,*iEXP0,*iEPOCH,*apcor,*apsize,*RAper,*RChi,*RSky0,*RSky1,*RSky20,*RSky21;
EXTERN float ***psf;
EXTERN dpostype *dpos,*dpos0;
EXTERN apskytype *apsky;
EXTERN imtype *datahd,*dataim;
EXTERN apsftype *apsf;
EXTERN hstmodetype *hstmode;
#endif

// Necessary Globals - used by main and camera-specific packages
EXTERN int Timg,Nimg;
EXTERN FILE *finfo;

EXTERN struct {
   int XMIN2,XMAX2,YMIN2,YMAX2,CUSE,GUSE,MaxIT,RPSF0,RCentroid,SecondPass,RandomFake,FakePad,PSFres,PSFPhot,PSFPhotIt,FitSky,ApCor,Align,AlignIter,AlignOnly,Rotate,Force1,SkipSky,FakeStarPSF,SearchMode,UseWCS,ForceSameMag,SubResRef,VerboseData,NegSky,PrintPass,SubPixel,FPSF,EPSF,PSFsol,FlagMask,CombineChi,WFPC2useCTE,ACSuseCTE,WFC3useCTE,InterpPSFlib,ACSpsfType,WFC3psfType[3],NIRCAMvega,NIRISSvega,MIRIvega,ROMANvega,NISPvega,templateexists;
   long MCSEED;
   double RAper0,RChi0,SigAlign,SigFind,SigFinal,NoiseMult,FSat,PosStep,dPosMax,RCombine,SigPSF,psfoff,RSky00,RSky10,RSky200,RSky210,SkySig,SigFindMult,FakeMatch,FakePSF,AlignTol,AlignStep,MinS,MaxS,MaxE,PSFStep,Zero;
   fntype outfn,alignstars,psfstars,xytfile,xytpsf,FakeStars,FakeOut,UsePhot,DiagPlotType;
   imgdatatype imgdata[MAXNIMG];
#ifdef DOLPHOT_THREADED
   int MaxThreadsHW;
#endif
} PARAM_DONOTREFERENCE;
#define GetParamInt(x) (int)(PARAM_DONOTREFERENCE.x)
#define GetParamLong(x) (int)(PARAM_DONOTREFERENCE.x)
#define GetParamFloat(x) (float)(PARAM_DONOTREFERENCE.x)
#define GetParamDouble(x) (double)(PARAM_DONOTREFERENCE.x)
#define GetParamChar(x) (char)(PARAM_DONOTREFERENCE.x[0])
#define GetParamString(x) (char*)(PARAM_DONOTREFERENCE.x)
#define SetParam_NOT_THREADSAFE(x,y) PARAM_DONOTREFERENCE.x=y
#define SetParamString_NOT_THREADSAFE(x,y) strcpy(PARAM_DONOTREFERENCE.x,y)

EXTERN struct {
   int DRIZZLE_BASE,IMDIFF,X,Y,XMIN,XMAX,YMIN,YMAX,WARMSTART,POSPSF,rpsfMax,rPhotPlusPSFmax,wcsminmax_set,fitpsf,NO_SKY;
   double RBig;
} GLOBAL_DONOTREFERENCE;
#define GetGlobalInt(x) (int)(GLOBAL_DONOTREFERENCE.x)
#define GetGlobalDouble(x) (double)(GLOBAL_DONOTREFERENCE.x)
#define SetGlobal_NOT_THREADSAFE(x,y) GLOBAL_DONOTREFERENCE.x=y
