#include <fits.h>
#include <unistd.h>

ftype fits;

int main(int argc,char**argv) {
   int ext,i,j,k,ntab=0;
   imtype *im;
   char fname[321];

   if (argc<3 || argc>4) {
      printf("Usage: %s <FITS file> <output> <<header>>\n",*argv);
      return -1;
   }
   readfits(argv[1],&fits,1);
   for (ext=0;ext<fits.Next;ext++) if (fits.ext[ext].bintabdata!=0) ntab++;
   if (ntab==0) {
      printf("ERROR: could not locate binary table\n");
      return -1;
   }
   if (ntab==1) printf("Found 1 binary table extension\n");
   else printf("Found %d binary table extensions\n",ntab);
   for (ext=0;ext<fits.Next;ext++) if (fits.ext[ext].bintabdata!=0) {
      im = fits.ext+ext;
      if (ntab==1) strcpy(fname,argv[2]);
      else sprintf(fname,"%s.%03d",argv[2],ext+1);
      FILE *f=fopen(fname,"w");
      if (!f) printf("ERROR: could not write \"%s\"\n",fname);
      else {
	 for (i=0;i<im->Y;i++) {
	    for (j=0;j<im->tfields;j++) {
	       fprintf(f," ");
	       for (k=0;k<im->bintabdata[j].length;k++) {
		  void *ptr = (void*) ( (char*)im->data[0][0] + i*im->X + im->bintabdata[j].offset + k*im->bintabdata[j].isize );
		  switch(im->bintabdata[j].type) {
		  case 'A':
		     if (*((char*)ptr)==0) fprintf(f," ");
		     else fprintf(f,im->bintabdata[j].format,*((char*)ptr));
		     break;
		  case 'B':
		     fprintf(f,im->bintabdata[j].format,*((int8_t*)ptr));
		     break;
		  case 'D':
		     fprintf(f,im->bintabdata[j].format,*((double*)ptr));
		     break;
		  case 'E':
		     fprintf(f,im->bintabdata[j].format,*((float*)ptr));
		     break;
		  case 'I':
		     fprintf(f,im->bintabdata[j].format,*((int16_t*)ptr));
		     break;
		  case 'J':
		     fprintf(f,im->bintabdata[j].format,*((int32_t*)ptr));
		     break;
		  case 'K':
		     fprintf(f,im->bintabdata[j].format,*((int64_t*)ptr));
		     break;
		  }
		  if (k<im->bintabdata[j].length-1 && im->bintabdata[j].type!='A') fprintf(f,",");
	       }
	    }
	    fprintf(f,"\n");
	 }
	 fclose(f);
      }
      if (argc==4) {
	 if (ntab==1) strcpy(fname,argv[3]);
	 else sprintf(fname,"%s.%03d",argv[3],ext+1);
	 f=fopen(fname,"w");
	 if (!f) printf("ERROR: could not write \"%s\"\n",fname);
	 else {
	    for (i=0;i<im->tfields;i++) fprintf(f,"%d. %s\n",i+1,im->bintabdata[i].name);
	    fclose(f);
	 }
      }
   }
   return 0;
}
