#include <stdio.h>
#include <math.h>
#include "wfpc2filters.h"

double CC[10][4]=
{{3.54356E+02,-8.12003E+02,-8.07068E+02,7.72904E+02},
 {1.00021E+00,1.95172E-02,-2.18757E+00,1.37619E-02},
 {9.79758E-04,-2.18805E+00,-8.51284E-03,2.18899E+00},
 {9.84222E-08,-1.51015E-06,-3.21458E-07,1.33326E-06},
 {-6.31327E-09,5.06693E-06,2.77459E-06,-4.00828E-06},
 {-7.19983E-07,1.04063E-06,-2.06874E-06,-5.71282E-07},
 {-3.73922E-08,-4.55094E-10,7.39223E-08,-2.00520E-09},
 {6.65101E-10,7.50249E-08,-1.18833E-09,-7.86673E-08},
 {-3.51470E-08,-1.51652E-09,7.73056E-08,-3.37491E-09},
 {-2.55003E-09,7.34568E-08,-3.72971E-10,-7.81490E-08}};
double DD[10][4]=
{{3.43646E+02,7.66592E+02,-7.71489E+02,-7.74638E+02},
 {1.00544E-03,2.18607E+00,7.40319E-03,-2.18688E+00},
 {9.99786E-01,2.02006E-02,-2.18554E+00,1.29831E-02},
 {-5.80870E-07,-3.79469E-06,-1.49841E-06,1.30814E-06},
 {-5.07221E-07,-2.99518E-06,2.96650E-06,2.01760E-06},
 {3.41574E-07,1.05789E-07,-2.02756E-07,-8.47656E-07},
 {-1.08091E-09,-7.47857E-08,-1.45720E-09,7.70408E-08},
 {-3.42070E-08,-1.67666E-09,7.72421E-08,-1.68514E-09},
 {1.17819E-09,-7.55302E-08,8.52633E-10,7.75257E-08},
 {-4.48966E-08,3.02579E-10,7.68023E-08,-3.69210E-10}};
double cc[10][4]=
{{4.28529E+01,4.99901E+01,2.91305E+01,4.06423E+01},
 {1.01839E+00,3.13580E-04,-4.65410E-01,6.89657E-03},
 {8.19691E-03,4.64781E-01,-2.53882E-03,-4.65172E-01},
 {-4.07640E-05,-2.44422E-06,-8.01738E-06,-2.85229E-06},
 {-2.44982E-05,5.28887E-06,-5.00071E-06,5.16479E-06},
 {-1.48524E-05,-7.39546E-06,-2.92348E-06,-7.91820E-06},
 {3.85393E-08,7.48860E-11,-3.32528E-09,2.55717E-11},
 {-8.32054E-10,3.41559E-09,8.12087E-11,-3.50591E-09},
 {3.65245E-08,-1.64561E-11,-3.50117E-09,-3.28654E-11},
 {2.58167E-09,3.37577E-09,4.45278E-11,-3.47401E-09}};
double dd[10][4]=
{{5.33594E+01,2.27199E+01,4.25019E+01,4.60263E+01},
 {7.27504E-03,-4.64924E-01,-5.86315E-03,4.64946E-01},
 {1.02076E+00,8.16708E-03,-4.65858E-01,-1.43623E-03},
 {-1.27390E-05,-7.93511E-06,-2.74006E-06,-8.16812E-06},
 {-2.37200E-05,4.68366E-06,-5.44820E-06,5.29464E-06},
 {-4.77746E-05,-2.98490E-06,-8.09822E-06,-2.99135E-06},
 {1.04890E-09,-3.30055E-09,4.25231E-11,3.51142E-09},
 {3.55851E-08,-7.84816E-12,-3.49983E-09,-1.12344E-10},
 {-1.40528E-09,-3.39413E-09,-5.98929E-11,3.55813E-09},
 {4.65028E-08,4.01436E-11,-3.46944E-09,-4.76932E-11}};

// chip X,Y -> undistorted frame
void WFPC2fwddistort(int c,double *x,double *y) {
   double x0=*x-399.5;
   double y0=*y-399.5;
   *x=CC[0][c]+CC[1][c]*x0+CC[2][c]*y0+CC[3][c]*x0*x0+CC[4][c]*x0*y0+CC[5][c]*y0*y0+CC[6][c]*x0*x0*x0+CC[7][c]*x0*x0*y0+CC[8][c]*x0*y0*y0+CC[9][c]*y0*y0*y0;
   *y=DD[0][c]+DD[1][c]*x0+DD[2][c]*y0+DD[3][c]*x0*x0+DD[4][c]*x0*y0+DD[5][c]*y0*y0+DD[6][c]*x0*x0*x0+DD[7][c]*x0*x0*y0+DD[8][c]*x0*y0*y0+DD[9][c]*y0*y0*y0;
}

// undistorted frame -> chip X,Y
void WFPC2revdistort(int c,double *x,double *y) {
   double x0=*x;
   double y0=*y;
   *x=cc[0][c]+cc[1][c]*x0+cc[2][c]*y0+cc[3][c]*x0*x0+cc[4][c]*x0*y0+cc[5][c]*y0*y0+cc[6][c]*x0*x0*x0+cc[7][c]*x0*x0*y0+cc[8][c]*x0*y0*y0+cc[9][c]*y0*y0*y0 - 0.5;
   *y=dd[0][c]+dd[1][c]*x0+dd[2][c]*y0+dd[3][c]*x0*x0+dd[4][c]*x0*y0+dd[5][c]*y0*y0+dd[6][c]*x0*x0*x0+dd[7][c]*x0*x0*y0+dd[8][c]*x0*y0*y0+dd[9][c]*y0*y0*y0 - 0.5;
}

double WFPC2xsize(int c,double x,double y) {
   double x1=x-0.5;
   double x2=x+0.5;
   double y1=y;
   double y2=y;
   WFPC2fwddistort(c,&x1,&y1);
   WFPC2fwddistort(c,&x2,&y2);
   return sqrt((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2))/sqrt(CC[1][c]*CC[1][c]+DD[1][c]*DD[1][c]);
}

double WFPC2ysize(int c,double x,double y) {
   double x1=x;
   double x2=x;
   double y1=y-0.5;
   double y2=y+0.5;
   WFPC2fwddistort(c,&x1,&y1);
   WFPC2fwddistort(c,&x2,&y2);
   return sqrt((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2))/sqrt(CC[2][c]*CC[2][c]+DD[2][c]*DD[2][c]);
}

// returns in PC standard pixel size
double WFPC2pixsize(int c,double x,double y) {
   double x1=x-0.5; double y1=y-0.5;
   double x2=x+0.5; double y2=y+0.5;
   double xa=x-0.5; double ya=y+0.5;
   double xb=x+0.5; double yb=y-0.5;
   WFPC2fwddistort(c,&x1,&y1);
   WFPC2fwddistort(c,&x2,&y2);
   WFPC2fwddistort(c,&xa,&ya);
   WFPC2fwddistort(c,&xb,&yb);
   y2-=y1;
   x2-=x1;
   return 0.5*fabs((xa-x1)*y2-(ya-y1)*x2)+0.5*fabs((xb-x1)*y2-(yb-y1)*x2);
}
