#include <dolphot.h>
#include "romanpsfdata.h"

void usage(char *exe) {
   printf("Usage: %s <filt> <chip> <Xpos> <Ypos> <dX> <dY> <<flags>>\n",exe);
   exit(-1);
}

int main(int argc,char**argv) {
   int chip,x,y,fx,fy,j,k,l,m,n;
   FILE *fpsf;
   char str[161];
   float **psf;

   if (argc!=7) usage(*argv);
   chip=atoi(argv[2]);
   if (chip<0 || chip>17) {
      printf("Chip must be 0-17\n");
      return -1;
   }
   x=atoi(argv[3]);
   if (x<0 || x>=roman_nxpsfpos) {
      printf("X position must be 0-%d\n",roman_nxpsfpos-1);
      return -1;
   }
   y=atoi(argv[4]);
   if (y<0 || y>=roman_nypsfpos) {
      printf("Y position must be 0-%d\n",roman_nypsfpos-1);
      return -1;
   }
   fx=atoi(argv[5]);
   fy=atoi(argv[6]);
   if (fx<-roman_n2psf || fx>roman_n2psf || fy<-roman_n2psf || fy>roman_n2psf) {
      printf("dX and dY must be -%d to %d\n",roman_n2psf,roman_n2psf);
      return -1;
   }
   sprintf(str,"%s/roman/data/%s.%s.psf",BASEDIR,argv[1],roman_cn[chip]);
   if ((fpsf=fopen(str,"rb"))==NULL) {
      printf("Cannot open %s\n",str);
      return -1;
   }
   psf=(float**)calloc(sizeof(float*),roman_rpsf*2+1);
   if (!psf) merr();
   psf+=roman_rpsf;
   for (j=-roman_rpsf;j<=roman_rpsf;j++) {
      psf[j]=(float*)calloc(sizeof(float),roman_rpsf*2+1);
      if (!psf[j]) merr();
      psf[j]+=roman_rpsf;
   }
   for (j=0;j<y;j++) for (k=0;k<roman_nxpsfpos;k++) for (l=-roman_n2psf;l<=roman_n2psf;l++) for (m=-roman_n2psf;m<=roman_n2psf;m++) for (n=-roman_rpsf;n<=roman_rpsf;n++) fread(psf[n]-roman_rpsf,4,2*roman_rpsf+1,fpsf);
   for (k=0;k<x;k++) for (l=-roman_n2psf;l<=roman_n2psf;l++) for (m=-roman_n2psf;m<=roman_n2psf;m++) for (n=-roman_rpsf;n<=roman_rpsf;n++) fread(psf[n]-roman_rpsf,4,2*roman_rpsf+1,fpsf);
   for (l=-roman_n2psf;l<fy;l++) for (m=-roman_n2psf;m<=roman_n2psf;m++) for (n=-roman_rpsf;n<=roman_rpsf;n++) fread(psf[n]-roman_rpsf,4,2*roman_rpsf+1,fpsf);
   for (m=-roman_n2psf;m<fx;m++) for (n=-roman_rpsf;n<=roman_rpsf;n++) fread(psf[n]-roman_rpsf,4,2*roman_rpsf+1,fpsf);
   for (n=-roman_rpsf;n<=roman_rpsf;n++) ffread(psf[n]-roman_rpsf,4,2*roman_rpsf+1,fpsf);
   k=roman_rpsf;
   if (k>6) k=6;
   for (n=k;n>=-k;n--) {
      for (j=-k;j<=k;j++) printf("%5d ",(int)(psf[n][j]*100000+0.5));
      printf("\n");
   }
   fclose(fpsf);
   return 0;
}
