#include <fits.h>
#include "romanpsfdata.h"

ftype fits,pam;
double RN,EXP,EXP0,EPOCH,FIXED_ET=-1.,FIXED_RN=-1.;
float DMIN,DMAX;
int NCOMBINE,Next0,USEDARK=1;
const double DARKERR = 0.00367; // electrons/sec residual

int ROMANtype(ftype *f) {
   char detector[21];

   if (Next0!=1 || f->ext[0].X!=4088 || f->ext[0].Y!=4088 || f->ext[0].Z!=1) {printf("**SCI image is not 4088x4088x1\n"); exit(-1);}
   strcpy(detector,getcardval(fits.ext,"DETECTOR",1));
   if (!strncmp(detector,"WFI",3) && (detector[3]=='0' || detector[3]=='1') && detector[4]>='0' && detector[4]<='9' && strlen(detector)==5) {
      int wfinum;
      wfinum = atoi(detector+3)-1;
      if (wfinum>=0 && wfinum<18) return wfinum;
   }
   printf("Detector %s not identified\n",detector);
   exit(-1);
}

double getEitherValue(char*str) {
   char *ptr = getcardval(&(fits.img),str,0);
   if (*ptr==0) ptr = getcardval(fits.ext,str,1);
   if (*ptr==0) exit(-1);
   return atof(ptr);
}

void ROMANgetcards(void) {
   float DARK=0;
   if (FIXED_ET>0) EXP=FIXED_ET;
   else EXP = getEitherValue("EXPTIME");
   if (FIXED_RN>0) RN=FIXED_RN;
   else RN = getEitherValue("RDNOISE");
   if (USEDARK) DARK=DARKERR*EXP;
   DMIN = -1.e29;
   DMAX = 1.e30;
   EPOCH = 0.0;
   NCOMBINE = 1;
   EXP0=EXP/NCOMBINE;
   RN = sqrt( RN*RN*NCOMBINE + DARK*DARK); // include multiple readouts and dark current rate
   printf("Effective readout noise = %4.2f electrons\n",RN);
   return;
}

void ROMANgetMaxMin(void) {
   int x,y;
   DMAX = 0.;
   DMIN = 0.;
   for (y=0;y<fits.ext[0].Y;y++) for (x=0;x<fits.ext[0].X;x++) {
      if (fits.ext[0].data[0][y][x]<DMIN) DMIN=fits.ext[0].data[0][y][x];
      if (fits.ext[0].data[0][y][x]>DMAX) DMAX=fits.ext[0].data[0][y][x];
   }
   if (DMAX>10) DMAX*=1.1;
   else DMAX++;
   if (DMIN<-10) DMIN*=1.1;
   else DMIN--;
}

/*
void ROMAN_DQ_mask(ftype*f,int ext,int drz,int ir) {
   int x,y,dq,i;
   for (y=0;y<f->ext[ext].Y;y++) for (x=0;x<f->ext[ext].X;x++) {
      dq=(int)(f->ext[ext+2].data[0][y][x]+0.5);
      // 1024 unused at present
      if (dq&256) f->ext[ext].data[0][y][x]=safeup(DMAX); // 256
      else if ((dq&512) && USE_FLAT_FLAG) f->ext[ext].data[0][y][x]=safedown(DMIN);
      else if (dq&6335) f->ext[ext].data[0][y][x]=safedown(DMIN); // 4096+2048+128+63
      else if ((dq&8192) && MASKCR) f->ext[ext].data[0][y][x]=safedown(DMIN);
   }
   return;
}
*/

/*
void ROMAN_PAM_mult(int ext,char*pamfn,double mult) {
   int x,y;
   float DMIN1,DMAX1;
   char fn[321];

   if (DMAX>0.) DMAX1=1.5*DMAX;
   else DMAX1=0.;
   if (DMIN<0.) DMIN1=1.5*DMIN;
   else DMIN1=0.;
   sprintf(fn,"%s/roman/data/%s",BASEDIR,pamfn);
   readfits(fn,&pam,0);
   if (pam.Next!=1 || pam.ext[0].X<fits.ext[ext].X+offsetx || pam.ext[0].Y<fits.ext[ext].Y+offsety || pam.ext[0].Z!=fits.ext[ext].Z) {
      printf("Error in PAM file %s\n",pamfn);
      exit(-1);
      return;
   }
   for (y=0;y<fits.ext[ext].Y;y++) for (x=0;x<fits.ext[ext].X;x++) if (fits.ext[ext].data[0][y][x]>DMIN && fits.ext[ext].data[0][y][x]<DMAX) {
      fits.ext[ext].data[0][y][x]*=pam.ext[0].data[0][y+offsety][x+offsetx]/mult;
      fits.ext[ext+1].data[0][y][x]*=pam.ext[0].data[0][y+offsety][x+offsetx]/mult;
   }
   else if (fits.ext[ext].data[0][y][x]>=DMAX) fits.ext[ext].data[0][y][x]=safeup(DMAX1);
   else fits.ext[ext].data[0][y][x]=safedown(DMIN1);
   freefits(&pam);
   DMIN=DMIN1;
   DMAX=DMAX1;
   return;
}
*/

void ROMAN_exptime_mult(void) {
   int x,y;

   DMAX*=EXP;
   DMIN*=EXP;
   for (y=0;y<fits.ext[0].Y;y++) for (x=0;x<fits.ext[0].X;x++) {
      fits.ext[0].data[0][y][x]*=EXP;
   }
   return;
}

void ROMANsetcards(void) {
   insertcards(fits.ext,1.,RN,EXP,DMIN,DMAX,EPOCH,0.0,EXP0);
   return;
}

int main(int argc,char**argv) {
   int i,tp;
   char str[101];

   if (argc<2) {
      printf("Usage: %s <<-flags>> <fits files>\n",*argv);
      printf(" -exptime=#   overrides exposure time\n");
      printf(" -rdnoise=#   overrides readout noise\n");
      printf(" -nodark      to ignore noise from dark residual\n");
      return 1;
   }
   for (i=1;i<argc;i++) if (!strncasecmp(argv[i],"-EXPTIME=",9)) FIXED_ET=atof(argv[i]+9);
   else if (!strncasecmp(argv[i],"-RDNOISE=",9)) FIXED_RN=atof(argv[i]+9);
   else if (!strcasecmp(argv[i],"-NODARK")) USEDARK=0;
   else {
      readfits(argv[i],&fits,1);
      Next0=fits.Next;
      tp=ROMANtype(&fits);
      if (Next0>0 && strcmp(getcardval(fits.ext,"DOL_ROMN",0),"")) printf("%s already run through romanmask\n",argv[i]);
      else if (tp<0 || tp>17) printf("%s is not a ROMAN fits file\n",argv[i]);
      else {
	 ROMANgetcards();
	 ROMANgetMaxMin();
	 //ROMAN_DQ_mask(&fits,0,0,1);
	 //ROMAN_PAM_mult(0,"ir_roman_map.fits",roman_ctmult[0]);
	 ROMAN_exptime_mult();
	 ROMANsetcards();
	 sprintf(str,"DOL_ROMN=                   %2d / DOLPHOT ROMAN tag                              ",tp);
	 addcard(fits.ext,str);
	 writefits(argv[i],&fits,1);
      }
      freefits(&fits);
   }
   return 0;
}
