#include <fits.h>
#include "romanpsfdata.h"

ftype fits;
char base[81]="Roman_STPSF2.1_samp9_npsf25";

float getpsf(char*filt,int chip) {
   int x,y,z,x1,y1,ct,cx,cy;
   FILE *f;
   char fn[321];
   float **psf,dr;
   double norm,normsum=0.,aparea=0.,apavg=0.;

   sprintf(fn,"%s/roman/data/%s.%s.psf",BASEDIR,filt,roman_cn[chip]);
   if ((f=fopen(fn,"wb"))==NULL) {
      printf("Cannot write %s\n",fn);
      exit(1);
   }
   psf=(float**)calloc(2*roman_rpsf+1,sizeof(float*));
   if (!psf) merr();
   psf+=roman_rpsf;
   for (z=-roman_rpsf;z<=roman_rpsf;z++) {
      psf[z]=(float*)calloc(2*roman_rpsf+1,sizeof(float));
      if (!psf[z]) merr();
      psf[z]+=roman_rpsf;
   }
   sprintf(fn,"%s/tmp/%s/wfi_wfi%02d_%s_fovp101_samp9_npsf25.fits",BASEDIR,base,chip+1,filt);
   readfits(fn,&fits,0);
   imtype *img = &(fits.img);
   //if (fits.Next>0) img = fits.ext;
   printf("%d %d %d\n",img->Z,img->X,img->Y);
   if (img->Z!=roman_npsfpos || img->X<1+2*(1+roman_rpsf)*roman_sub || img->Y<roman_sub || img->X%2==0 || img->Y%2==0) {printf("Illegal format of PSF file (must be %dx%d or larger and have central pixel)\n",1+2*(1+roman_rpsf)*roman_nxpsfpos,1+2*(1+roman_rpsf)*roman_nxpsfpos); exit(-1);}
   cx = img->X/2;
   cy = img->Y/2;
   for (ct=0;ct<roman_npsfpos;ct++) {
      int indx;
      x = ct%roman_nxpsfpos;
      y = ct/roman_nxpsfpos;
      indx = x*roman_nypsfpos + y; // input file has "fast" axis of Y
      // Confirm peak on central pixel
      for (y=0;y<img->Y;y++) for (x=0;x<img->X;x++) if ((y!=cy || x!=cx) && img->data[indx][y][x]>img->data[indx][cy][cx]) printf("Warning: %d,%d not center (%d,%d higher)\n",cx,cy,x,y);
      norm=0;
      for (y=0;y<img->Y;y++) for (x=0;x<img->X;x++) norm += img->data[indx][y][x];
      norm/=roman_sub*roman_sub;
      normsum += norm;
      printf("%3d: total PSF=%f\n",ct,norm);
      // loop over subpixel phasing (x,y)
      for (y=-roman_n2psf;y<=roman_n2psf;y++) for (x=-roman_n2psf;x<=roman_n2psf;x++) {
	 // Note: using undistorted PSFs so not normalizing psf[][] to sum to 1.0 - STPSF shows PSF normalization variation with SCA
	 for (y1=-roman_rpsf;y1<=roman_rpsf;y1++) for (x1=-roman_rpsf;x1<=roman_rpsf;x1++) psf[y1][x1] = img->data[indx][cy-y+y1*roman_sub][cx-x+x1*roman_sub];
	 for (y1=-roman_rpsf;y1<=roman_rpsf;y1++) ffwrite(psf[y1]-roman_rpsf,2*roman_rpsf+1,sizeof(float),f);
	 // Compute EE corrections assuming normalized PSF
	 if (y>-roman_n2psf && y<roman_n2psf && x>-roman_n2psf && x<roman_n2psf) {
	 for (y1=-roman_rpsf;y1<=roman_rpsf;y1++) for (x1=-roman_rpsf;x1<=roman_rpsf;x1++) {
	    dr = 10.465 - sqrt(x1*x1+y1*y1);
	    if (dr>0.) {
	       if (dr>1.) dr=1.;
	       aparea += dr;
	       apavg += dr*psf[y1][x1];
	    }
	 }
	 }
      }
   }
   for (z=-roman_rpsf;z<=roman_rpsf;z++) free(psf[z]-roman_rpsf);
   free(psf-roman_rpsf);
   fclose(f);
   apavg /= roman_npsfpos*roman_sub*roman_sub;
   aparea /= roman_npsfpos*roman_sub*roman_sub;
   printf("Average PSF normalization: %f\n",normsum/roman_npsfpos);
   printf("EEap=%6.4f mags (%5.3f pixel effective aperture)\n",-2.5*log10(apavg),sqrt(aparea/M_PI));
   return apavg;
}

int main(int argc,char**argv) {
   int nfilt=0,i,j;
   char filt[100][20];

   if (argc<2) {
      printf("Usage: %s <filters> <<opts>>\n",*argv);
      printf("  -base=<dirname>   to use data directory other than\n");
      printf("                    Roman_STPSF2.0.0_samp9_npsf25_nodistort\n");
      return -1;
   }
   for (i=1;i<argc;i++) {
      if (!strcmp(argv[i],"F062") || !strcmp(argv[i],"F087") || !strcmp(argv[i],"F106") || !strcmp(argv[i],"F129") || !strcmp(argv[i],"F146") || !strcmp(argv[i],"F158") || !strcmp(argv[i],"F184") || !strcmp(argv[i],"F213")) strcpy(filt[nfilt++],argv[i]);
      else if (!strncasecmp(argv[i],"-base=",6)) strcpy(base,argv[i]+6);
      else {
	 printf("Unknown option: \"%s\"\n",argv[i]);
	 return -1;
      }
   }
   for (i=0;i<nfilt;i++) {
      float apavg=0;
      for (j=0;j<18;j++) {
      //for (j=1;j<2;j++) {
	 apavg += getpsf(filt[i],j);
      }
      apavg /= 18;
      printf("Average PSF total = %f (%f mags)\n",apavg,-2.5*log10(apavg));
   }
   return 0;
}
