#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <math.h>

#include "romanfilters.h"
/*
typedef struct {
   char name[11],color;
   double zp;
} ROMANfilttype;
*/

int ROMAN_NFILTERS=-1;
ROMANfilttype *ROMANfilters;

static void readdata(void) {
   int i;
   FILE *f;
   char str[1025];
   double eecorr;

   sprintf(str,"%s/roman/data/filters.dat",BASEDIR);
   if ((f=fopen(str,"r"))==NULL) {
      printf("Could not find %s\n",str);
      exit(0);
   }
   fscanf(f,"%d",&ROMAN_NFILTERS);
   fgets(str,81,f);
   ROMANfilters=(ROMANfilttype*)calloc(sizeof(ROMANfilttype),ROMAN_NFILTERS);
   assert(ROMANfilters!=NULL);
   for (i=0;i<ROMAN_NFILTERS;i++) {
      fgets(ROMANfilters[i].name,11,f); ROMANfilters[i].name[strlen(ROMANfilters[i].name)-1]=0;
      ROMANfilters[i].color=fgetc(f);
      fgets(str,81,f);
      fscanf(f,"%lf %lf",&ROMANfilters[i].zpAB,&ROMANfilters[i].zp);
      fscanf(f,"%lf",&eecorr);
      fgets(str,81,f);
      //applying encircled energy correction afterwards since .xform is differential;
      ROMANfilters[i].zpAB-=eecorr;
      ROMANfilters[i].zp-=eecorr;
   }
   fclose(f);
   return;
}

int ROMANfindfilt(char*str) {
   int i;
   void ROMANinitfilters();
   if (ROMAN_NFILTERS<0) ROMANinitfilters();
   for (i=0;i<ROMAN_NFILTERS;i++) if (!strcmp(ROMANfilters[i].name,str)) return i;
   printf("Illegal filter %s\n",str);
   exit(0);
   return -1;
}

void ROMANinitfilters(void) {
   readdata();
   return;
}

void ROMANtransform(double vmag[],double dvmag[],double smag[]) {
   int f;
   if (ROMAN_NFILTERS<0) ROMANinitfilters();
   for (f=0;f<ROMAN_NFILTERS;f++) smag[f]=99.999;
}

double ROMANuntransform(int filt,double smag[5]) {
   return 99999.;
}
