#include <dolphot.h>
#include "nirisspsfdata.h"

void usage(char *exe) {
   printf("Usage: %s <filt> <Xpos> <Ypos> <dX> <dY> <<flags>>\n",exe);
   exit(-1);
}

int main(int argc,char**argv) {
   int x,y,fx,fy,j,k,l,m,n;
   FILE *fpsf;
   char str[161];
   float **psf;

   if (argc!=6) usage(*argv);
   x=atoi(argv[2]);
   if (x<0 || x>=niriss_nxpsfpos) {
      printf("X position must be 0-%d\n",niriss_nxpsfpos-1);
      return -1;
   }
   y=atoi(argv[3]);
   if (y<0 || y>=niriss_nypsfpos) {
      printf("Y position must be 0-%d\n",niriss_nypsfpos-1);
      return -1;
   }
   fx=atoi(argv[4]);
   fy=atoi(argv[5]);
   if (fx<-niriss_n2psf || fx>niriss_n2psf || fy<-niriss_n2psf || fy>niriss_n2psf) {
      printf("dX and dY must be -%d to %d\n",niriss_n2psf,niriss_n2psf);
      return -1;
   }
   sprintf(str,"%s/niriss/data/%s.psf",BASEDIR,argv[1]);
   if ((fpsf=fopen(str,"rb"))==NULL) {
      printf("Cannot open %s\n",str);
      return -1;
   }
   psf=(float**)calloc(sizeof(float*),niriss_rpsf*2+1);
   if (!psf) merr();
   psf+=niriss_rpsf;
   for (j=-niriss_rpsf;j<=niriss_rpsf;j++) {
      psf[j]=(float*)calloc(sizeof(float),niriss_rpsf*2+1);
      if (!psf[j]) merr();
      psf[j]+=niriss_rpsf;
   }
   for (j=0;j<y;j++) for (k=0;k<niriss_nxpsfpos;k++) for (l=-niriss_n2psf;l<=niriss_n2psf;l++) for (m=-niriss_n2psf;m<=niriss_n2psf;m++) for (n=-niriss_rpsf;n<=niriss_rpsf;n++) fread(psf[n]-niriss_rpsf,4,2*niriss_rpsf+1,fpsf);
   for (k=0;k<x;k++) for (l=-niriss_n2psf;l<=niriss_n2psf;l++) for (m=-niriss_n2psf;m<=niriss_n2psf;m++) for (n=-niriss_rpsf;n<=niriss_rpsf;n++) fread(psf[n]-niriss_rpsf,4,2*niriss_rpsf+1,fpsf);
   for (l=-niriss_n2psf;l<fy;l++) for (m=-niriss_n2psf;m<=niriss_n2psf;m++) for (n=-niriss_rpsf;n<=niriss_rpsf;n++) fread(psf[n]-niriss_rpsf,4,2*niriss_rpsf+1,fpsf);
   for (m=-niriss_n2psf;m<fx;m++) for (n=-niriss_rpsf;n<=niriss_rpsf;n++) fread(psf[n]-niriss_rpsf,4,2*niriss_rpsf+1,fpsf);
   for (n=-niriss_rpsf;n<=niriss_rpsf;n++) ffread(psf[n]-niriss_rpsf,4,2*niriss_rpsf+1,fpsf);
   k=niriss_rpsf;
   if (k>6) k=6;
   for (n=k;n>=-k;n--) {
      for (j=-k;j<=k;j++) printf("%5d ",(int)(psf[n][j]*100000+0.5));
      printf("\n");
   }
   fclose(fpsf);
   return 0;
}
