#include <fits.h>
#include "nirisspsfdata.h"

ftype fits;
char base[81]="NIRISS_FullGrid_Normalized_V4";

float getpsf(char*filt) {
   int x,y,z,x1,y1,ct,cx,cy;
   FILE *f;
   char fn[321];
   float **psf,dr;
   double norm,aparea=0.,apavg=0.;

   sprintf(fn,"%s/niriss/data/%s.psf",BASEDIR,filt);
   if ((f=fopen(fn,"wb"))==NULL) {
      printf("Cannot write %s\n",fn);
      exit(1);
   }
   psf=(float**)calloc(2*niriss_rpsf+1,sizeof(float*));
   if (!psf) merr();
   psf+=niriss_rpsf;
   for (z=-niriss_rpsf;z<=niriss_rpsf;z++) {
      psf[z]=(float*)calloc(2*niriss_rpsf+1,sizeof(float));
      if (!psf[z]) merr();
      psf[z]+=niriss_rpsf;
   }
   sprintf(fn,"%s/tmp/%s/PSF_%s_fov51_npsfs25_nis.fits",BASEDIR,base,filt);
   readfits(fn,&fits,0);
   imtype *img = &(fits.img);
   //if (fits.Next>0) img = fits.ext;
   printf("%d %d %d\n",img->Z,img->X,img->Y);
   if (img->Z!=niriss_npsfpos || img->X<255 || img->Y<255) {printf("Illegal format of PSF file (must be 255x255 or larger\n"); exit(-1);}
   cx = img->X/2;
   cy = img->Y/2;
   for (ct=0;ct<niriss_npsfpos;ct++) {
      int indx;
      x = ct%niriss_nxpsfpos;
      y = ct/niriss_nxpsfpos;
      indx = x*niriss_nypsfpos + y; // input file has "fast" axis of Y
      // Confirm central nine pixels
      for (y=0;y<img->Y;y++) for (x=0;x<img->X;x++) {
	 if ((y!=cy-1 && y!=cy && y!=cy+1) || (x!=cx-1 && x!=cx && x!=cx+1)) {
	    if (img->data[indx][y][x]>=img->data[indx][cy-1][cx-1] || img->data[indx][y][x]>=img->data[indx][cy-1][cx] || img->data[indx][y][x]>=img->data[indx][cy][cx-1] || img->data[indx][y][x]>=img->data[indx][cy][cx]) printf("Warning: %d,%d not center (%d,%d higher)\n",cx,cy,x,y);
	 }
      }
      norm=0;
      for (y=0;y<img->Y;y++) for (x=0;x<img->X;x++) {
	 //img->data[indx][y][x] /= 25; // 5x5 oversampling
	 norm += img->data[indx][y][x];
      }
      printf("%3d: total PSF=%f\n",ct,norm/25);
      // loop over subpixel phasing (x,y)
      for (y=-niriss_n2psf;y<=niriss_n2psf;y++) for (x=-niriss_n2psf;x<=niriss_n2psf;x++) {
	    /*
	 for (y1=-niriss_rpsf;y1<=niriss_rpsf;y1++) for (x1=-niriss_rpsf;x1<=niriss_rpsf;x1++) psf[y1][x1]=0.;
	 // simple -- no charge diffusion or delta QE
	 // assume 15x15 subsampled raw image (regardless of niriss_sub)
	 // assume niriss_sub=5 so get 3*x and 3*y math below
	 for (y1=0;y1<img->Y;y1++) for (x1=0;x1<img->X;x1++) {
	    x2=(x1-cx+5+3*x+1000*15)/15-1000;
	    y2=(y1-cy+5+3*y+1000*15)/15-1000;
	    if (x2>=-niriss_rpsf && x2<=niriss_rpsf && y2>=-niriss_rpsf && y2<=niriss_rpsf) psf[y2][x2] += img->data[indx][y1][x1];
	 }
	    */
	 // simpler code, assuming EPSF usage and 5x5 oversampling
	 for (y1=-niriss_rpsf;y1<=niriss_rpsf;y1++) for (x1=-niriss_rpsf;x1<=niriss_rpsf;x1++) psf[y1][x1] = img->data[indx][cy-y+y1*5][cx-x+x1*5];
	 for (y1=-niriss_rpsf;y1<=niriss_rpsf;y1++) ffwrite(psf[y1]-niriss_rpsf,2*niriss_rpsf+1,sizeof(float),f);
	 // Compute EE corrections assuming normalized PSF
	 if (y>-niriss_n2psf && y<niriss_n2psf && x>-niriss_n2psf && x<niriss_n2psf) {
	 for (y1=-niriss_rpsf;y1<=niriss_rpsf;y1++) for (x1=-niriss_rpsf;x1<=niriss_rpsf;x1++) {
	    dr = 10.465 - sqrt(x1*x1+y1*y1);
	    if (dr>0.) {
	       if (dr>1.) dr=1.;
	       aparea += dr;
	       apavg += dr*psf[y1][x1];
	    }
	 }
	 }
      }
   }
   for (z=-niriss_rpsf;z<=niriss_rpsf;z++) free(psf[z]-niriss_rpsf);
   free(psf-niriss_rpsf);
   fclose(f);
   apavg /= niriss_npsfpos*niriss_sub*niriss_sub;
   aparea /= niriss_npsfpos*niriss_sub*niriss_sub;
   printf("EEap=%6.4f mags (%5.3f pixel effective aperture)\n",-2.5*log10(apavg),sqrt(aparea/M_PI));
   return apavg;
}

int main(int argc,char**argv) {
   int nfilt=0,i;
   char filt[100][20];

   if (argc<2) {
      printf("Usage: %s <filters> <<opts>>\n",*argv);
      printf("  -base=<dirname>   to use data directory other than NIRISS\n");
      return -1;
   }
   for (i=1;i<argc;i++) {
      if (!strcmp(argv[i],"F090W") || !strcmp(argv[i],"F115W") || !strcmp(argv[i],"F140M") || !strcmp(argv[i],"F150W") || !strcmp(argv[i],"F158M") || !strcmp(argv[i],"F200W") || !strcmp(argv[i],"F277W") || !strcmp(argv[i],"F356W") || !strcmp(argv[i],"F380M") || !strcmp(argv[i],"F430M") || !strcmp(argv[i],"F444W") || !strcmp(argv[i],"F480M")) strcpy(filt[nfilt++],argv[i]);
      else if (!strncasecmp(argv[i],"-base=",6)) strcpy(base,argv[i]+6);
      else {
	 printf("Unknown option: \"%s\"\n",argv[i]);
	 return -1;
      }
   }
   for (i=0;i<nfilt;i++) {
      float apavg = getpsf(filt[i]);
      printf("Average PSF total = %f (%f mags)\n",apavg,-2.5*log10(apavg));
   }
   return 0;
}
