#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <math.h>

#include "nirissfilters.h"

int NIRISS_NFILTERS=-1;
NIRISSfilttype *NIRISSfilters;

static void readdata(void) {
   int i;
   FILE *f;
   char str[1025];
   double eecorr;

   sprintf(str,"%s/niriss/data/filters.dat",BASEDIR);
   if ((f=fopen(str,"r"))==NULL) {
      printf("Could not find %s\n",str);
      exit(0);
   }
   fscanf(f,"%d",&NIRISS_NFILTERS);
   fgets(str,81,f);
   NIRISSfilters=(NIRISSfilttype*)calloc(sizeof(NIRISSfilttype),NIRISS_NFILTERS);
   assert(NIRISSfilters!=NULL);
   for (i=0;i<NIRISS_NFILTERS;i++) {
      fgets(NIRISSfilters[i].name,11,f); NIRISSfilters[i].name[strlen(NIRISSfilters[i].name)-1]=0;
      NIRISSfilters[i].color=fgetc(f);
      fgets(str,81,f);
      fscanf(f,"%lf %lf",&NIRISSfilters[i].zp,&eecorr);
      fgets(str,81,f);
      //applying encircled energy correction afterwards since .xform is differential;
      NIRISSfilters[i].zp -= eecorr;
      NIRISSfilters[i].zpJy = -eecorr;
   }
   fclose(f);
   return;
}

int NIRISSfindfilt(char*str) {
   int i;
   void NIRISSinitfilters();
   if (NIRISS_NFILTERS<0) NIRISSinitfilters();
   for (i=0;i<NIRISS_NFILTERS;i++) if (!strcmp(NIRISSfilters[i].name,str)) return i;
   printf("Illegal filter %s\n",str);
   exit(0);
   return -1;
}

void NIRISSinitfilters(void) {
   readdata();
   return;
}

void NIRISStransform(double vmag[],double dvmag[],double smag[]) {
   int f;
   if (NIRISS_NFILTERS<0) NIRISSinitfilters();
   for (f=0;f<NIRISS_NFILTERS;f++) smag[f]=99.999;
}

double NIRISSuntransform(int filt,double smag[5]) {
   return 99999.;
}
