#include <dolphot.h>
#include "nircampsfdata.h"

void usage(char *exe) {
   printf("Usage: %s <filt> <chip> <Xpos> <Ypos> <dX> <dY> <<flags>>\n",exe);
   exit(-1);
}

int main(int argc,char**argv) {
   int chip,x,y,fx,fy,j,k,l,m,n;
   FILE *fpsf;
   char str[161];
   float **psf;

   if (argc!=7) usage(*argv);
   chip=atoi(argv[2]);
   if (chip<0 || chip>9) {
      printf("Chip must be 0-9\n");
      return -1;
   }
   x=atoi(argv[3]);
   if (x<0 || x>=nircam_nxpsfpos) {
      printf("X position must be 0-%d\n",nircam_nxpsfpos-1);
      return -1;
   }
   y=atoi(argv[4]);
   if (y<0 || y>=nircam_nypsfpos) {
      printf("Y position must be 0-%d\n",nircam_nypsfpos-1);
      return -1;
   }
   fx=atoi(argv[5]);
   fy=atoi(argv[6]);
   if (fx<-nircam_n2psf || fx>nircam_n2psf || fy<-nircam_n2psf || fy>nircam_n2psf) {
      printf("dX and dY must be -%d to %d\n",nircam_n2psf,nircam_n2psf);
      return -1;
   }
   sprintf(str,"%s/nircam/data/%s.%s.psf",BASEDIR,argv[1],nircam_cn[chip]);
   if ((fpsf=fopen(str,"rb"))==NULL) {
      printf("Cannot open %s\n",str);
      return -1;
   }
   psf=(float**)calloc(sizeof(float*),nircam_rpsf*2+1);
   if (!psf) merr();
   psf+=nircam_rpsf;
   for (j=-nircam_rpsf;j<=nircam_rpsf;j++) {
      psf[j]=(float*)calloc(sizeof(float),nircam_rpsf*2+1);
      if (!psf[j]) merr();
      psf[j]+=nircam_rpsf;
   }
   for (j=0;j<y;j++) for (k=0;k<nircam_nxpsfpos;k++) for (l=-nircam_n2psf;l<=nircam_n2psf;l++) for (m=-nircam_n2psf;m<=nircam_n2psf;m++) for (n=-nircam_rpsf;n<=nircam_rpsf;n++) fread(psf[n]-nircam_rpsf,4,2*nircam_rpsf+1,fpsf);
   for (k=0;k<x;k++) for (l=-nircam_n2psf;l<=nircam_n2psf;l++) for (m=-nircam_n2psf;m<=nircam_n2psf;m++) for (n=-nircam_rpsf;n<=nircam_rpsf;n++) fread(psf[n]-nircam_rpsf,4,2*nircam_rpsf+1,fpsf);
   for (l=-nircam_n2psf;l<fy;l++) for (m=-nircam_n2psf;m<=nircam_n2psf;m++) for (n=-nircam_rpsf;n<=nircam_rpsf;n++) fread(psf[n]-nircam_rpsf,4,2*nircam_rpsf+1,fpsf);
   for (m=-nircam_n2psf;m<fx;m++) for (n=-nircam_rpsf;n<=nircam_rpsf;n++) fread(psf[n]-nircam_rpsf,4,2*nircam_rpsf+1,fpsf);
   for (n=-nircam_rpsf;n<=nircam_rpsf;n++) ffread(psf[n]-nircam_rpsf,4,2*nircam_rpsf+1,fpsf);
   k=nircam_rpsf;
   if (k>6) k=6;
   for (n=k;n>=-k;n--) {
      for (j=-k;j<=k;j++) printf("%5d ",(int)(psf[n][j]*100000+0.5));
      printf("\n");
   }
   fclose(fpsf);
   return 0;
}
