#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <fits.h>
#include "../dolphot_defs.h"
#include "nircampsfdata.h"
#include "nircamfilters.h"
#include "nircamdistort.h"

extern void shift(int img,double x0,double y0,double *x,double *y,int dir);

static float********nircampsflib=NULL;
static int NIRCAM_RPSF=24;
static int ANY_NIRCAM=0;

void nircaminitparam(void) {
   char str[161],*ptr;
   int img;
   ANY_NIRCAM=0;
   for (img=0;img<Timg && !ANY_NIRCAM;img++) {
      strcpy(str,getcardval(dataim+img,"DOL_NIRC",0));
      strtol(str,&ptr,10);
      if (ptr!=str) ANY_NIRCAM=1;
   }
   if (ANY_NIRCAM==0) return;
   ZeroCameraPars();
   return;
}

#define SetGlobal(x,y) GLOBAL_DONOTREFERENCE.x=y
void nircaminitpsf(void) {
   int img,i,j,y1,x1,y2,x2,y3,n2,n3,n3skip;
   char str[161],*ptr;
   FILE *f;
   float***** ptr1;
   float**** ptr2;
   float*** ptr3;
   float** ptr4;
   float* ptr5;

   if (NIRCAM_NFILTERS<0) NIRCAMinitfilters();
   if (nircampsflib==NULL) {
      nircampsflib=(float********)calloc(sizeof(float*******),10);
      if (!nircampsflib) merr();
      for (i=0;i<10;i++) {
	 nircampsflib[i]=(float*******)calloc(sizeof(float******),NIRCAM_NFILTERS);
	 if (!nircampsflib[i]) merr();
      }
   }
   for (i=0;i<10;i++) for (j=0;j<NIRCAM_NFILTERS;j++) nircampsflib[i][j]=NULL;
   for (img=0;img<Timg;img++) {
      strcpy(str,getcardval(dataim+img,"DOL_NIRC",0));
      int cm=strtol(str,&ptr,10);
      if (str[0]==0) {
	 // AEDDEBUG need warning: printf("**Image %d has not been preprocessed with nircammask; cannot proceed\n",img+1);
      }
      else {
	 if (cm<-2 || cm>9) {
	    printf("**Image %d's chip cannot be identified; please report bug.\n",img+1);
	    exit(-1);
	 }
	 hstmode[img].inst=NIRCAM;
	 hstmode[img].cm=cm;
	 if (img==Nimg) {
	    if (hstmode[img].cm==-2) {
	       hstmode[img].cm=9;
	       SetGlobal(DRIZZLE_BASE,1);
	    }
	    else if (hstmode[img].cm==-1) {
	       hstmode[img].cm=4;
	       SetGlobal(DRIZZLE_BASE,1);
	    }
	    else SetGlobal(DRIZZLE_BASE,0);
	 }
	 if (hstmode[img].cm<0) {
	    printf("**Image %d has been drizzled; cannot run photometry\n",img+1);
	    exit(-1);
	 }
	 hstmode[img].data1 = atof(getcardval(dataim+img,"DOL_C2JY",1));
	 // pupil contains F162M, F164N, F323N, F405N, F466N, and F470N - otherwise CLEAR is used
	 strcpy(str,getcardval(datahd+img,"PUPIL",0));
	 if (str[0]!='F' || str[1]<'0' || str[1]>'9') strcpy(str,getcardval(datahd+img,"FILTER",0));
	 hstmode[img].filt=NIRCAMfindfilt(str);
	 //printf("Image %d: filt=%d (%s)\n",img+1,hstmode[img].filt,NIRCAMfilters[hstmode[img].filt].name);
	 if (RPSF[img]>=nircam_rpsf) {RPSF[img]=nircam_rpsf-1; printf("Lowering RPSF to %d\n",RPSF[img]);}
	 if (RAper[img]>nircam_rpsf-1.) {RAper[img]=nircam_rpsf-1; printf("Lowering RAper to %g\n",RAper[img]);}
      }
   }
   NIRCAM_RPSF=0;
   for (img=0;img<Timg;img++) if (hstmode[img].inst==NIRCAM) {
      apsf[img][0][0]=1.;
      apsf[img][1][0]=1.;
      apsf[img][2][0]=0.;
      apsize[img]=10.;
      for (i=1;i<5;i++) apsf[img][0][i]=apsf[img][1][i]=apsf[img][2][i]=0.;
      if (NIRCAM_RPSF<RPSF[img]) NIRCAM_RPSF=RPSF[img];
      if (NIRCAM_RPSF<rphot[img]) NIRCAM_RPSF=rphot[img];
   }
   for (img=0;img<Timg;img++) if (hstmode[img].inst==NIRCAM && nircampsflib[i=hstmode[img].cm][j=hstmode[img].filt]==NULL) {
      sprintf(str,"%s/nircam/data/%s.%s.psf",BASEDIR,NIRCAMfilters[hstmode[img].filt].name,nircam_cn[i]);
      if ((f=fopen(str,"rb"))==NULL) {
	 printf("Cannot open %s\n",str);
	 exit(-1);
      }
      n2=2*nircam_n2psf+1;
      n3=2*NIRCAM_RPSF+1;
      n3skip=nircam_rpsf-NIRCAM_RPSF;
      nircampsflib[i][j]=(float******)calloc(sizeof(float*****),nircam_nypsfpos);
      ptr1=(float*****)calloc(sizeof(float****),nircam_nypsfpos*nircam_nxpsfpos);
      ptr2=(float****)calloc(sizeof(float***),nircam_nypsfpos*nircam_nxpsfpos*n2);
      ptr3=(float***)calloc(sizeof(float**),nircam_nypsfpos*nircam_nxpsfpos*n2*n2);
      ptr4=(float**)calloc(sizeof(float*),nircam_nypsfpos*nircam_nxpsfpos*n2*n2*n3);
      ptr5=(float*)calloc(sizeof(float),nircam_nypsfpos*nircam_nxpsfpos*n2*n2*n3*n3);
      if (!nircampsflib[i][j] || !ptr1) merr();
      for (y1=0;y1<nircam_nypsfpos;y1++) {
	 nircampsflib[i][j][y1]=ptr1;
	 ptr1+=nircam_nxpsfpos;
	 for (x1=0;x1<nircam_nxpsfpos;x1++) {
	    nircampsflib[i][j][y1][x1]=ptr2+nircam_n2psf;
	    ptr2+=n2;
	    for (y2=-nircam_n2psf;y2<=nircam_n2psf;y2++) {
	       nircampsflib[i][j][y1][x1][y2]=ptr3+nircam_n2psf;
	       ptr3+=n2;
	       for (x2=-nircam_n2psf;x2<=nircam_n2psf;x2++) {
		  nircampsflib[i][j][y1][x1][y2][x2]=ptr4+NIRCAM_RPSF;
		  ptr4+=n3;
		  if (n3skip) fseek(f,4*n3skip*(2*nircam_rpsf+1),SEEK_CUR);
		  for (y3=-NIRCAM_RPSF;y3<=NIRCAM_RPSF;y3++) {
		     nircampsflib[i][j][y1][x1][y2][x2][y3]=ptr5+NIRCAM_RPSF;
		     ptr5+=n3;
		     if (n3skip) fseek(f,4*n3skip,SEEK_CUR);
		     ffread(nircampsflib[i][j][y1][x1][y2][x2][y3]-NIRCAM_RPSF,4,n3,f);
		     if (n3skip) fseek(f,4*n3skip,SEEK_CUR);
		  }
		  if (n3skip) fseek(f,4*n3skip*(2*nircam_rpsf+1),SEEK_CUR);
	       }
	    }
	 }
      }
      fclose(f);
   }
   return;
}
#undef SetGlobal

void nircamfreepsf(void) {
   int i,j;
   for (i=0;i<10;i++) for (j=0;j<NIRCAM_NFILTERS;j++) if (nircampsflib[i][j]) {
      free(nircampsflib[i][j][0][0][-nircam_n2psf][-nircam_n2psf][-NIRCAM_RPSF]-NIRCAM_RPSF);
      free(nircampsflib[i][j][0][0][-nircam_n2psf][-nircam_n2psf]-NIRCAM_RPSF);
      free(nircampsflib[i][j][0][0][-nircam_n2psf]-nircam_n2psf);
      free(nircampsflib[i][j][0][0]-nircam_n2psf);
      free(nircampsflib[i][j][0]);
      free(nircampsflib[i][j]);
      nircampsflib[i][j]=NULL;
   }
   return;
}

//#define DEBUG_PSF
int calcnircampsf(int img,float x,float y,int r,int force) {
   int i,j,y1,x1,y2,x2,yy,xx;
   float mx1=1,my1=1,imx1=0,imy1=0;
   float mx2,my2,imx2,imy2;
   static int first=1,firstimg[MAXNIMG],lastr[MAXNIMG];
   static float lastx[MAXNIMG],lasty[MAXNIMG];

   if (hstmode[img].inst!=NIRCAM) {
      printf("Stupid error; called nircampsf for non-NIRCAM data\n");
      exit(-1);
   }
   if (first) {
#ifdef DOLPHOT_THREADED
#pragma omp critical
      if (first) {
#endif
	 for (i=0;i<Timg;i++) firstimg[i]=1;
	 first=0;
#ifdef DOLPHOT_THREADED
      }
#endif
   }
   if (!firstimg[img] && lastpsftype[img]==1 && x==lastx[img] && y==lasty[img] && r<=lastr[img] && !poffreset && !force) return 0;
   firstimg[img]=0;lastpsftype[img]=1;lastx[img]=x;lasty[img]=y;lastr[img]=r;
   i=hstmode[img].cm;
   j=hstmode[img].filt;
#ifdef DEBUG_PSF
   printf("%d %d %f %f %d",img,j,x,y,r);
   printf("%s/%s PSF at %f,%f; r=%d:\n",nircam_cn[i],NIRCAMfilters[j].name,x,y,r);
   fflush(stdout);
#endif
   imy2=y-(int)y;
   if (imy2<0) imy2++;
   imy2=(imy2-0.5)*nircam_sub;
   y2=(int)(imy2+nircam_sub)-nircam_sub;
   imy2-=y2; my2=1-imy2;
   imx2=x-(int)x;
   if (imx2<0) imx2++;
   imx2=(imx2-0.5)*nircam_sub;
   x2=(int)(imx2+nircam_sub)-nircam_sub;
   imx2-=x2; mx2=1-imx2;
   if (GetParamInt(InterpPSFlib) && (img<Nimg || !GetGlobalInt(DRIZZLE_BASE))) {
      imx1 = x/512.0;
      imy1 = y/512.0;
      if (imx1<=0.0) {x1=0; imx1=0.0;}
      else if (imx1>=nircam_nxpsfpos-1.0) {x1=nircam_nxpsfpos-2; imx1=1.0;}
      else {x1=(int)imx1; imx1-=x1;}
      mx1 = 1.0-imx1;
      if (imy1<=0.0) {y1=0; imy1=0.0;}
      else if (imy1>=nircam_nypsfpos-1.0) {y1=nircam_nypsfpos-2; imy1=1.0;}
      else {y1=(int)imy1; imy1-=y1;}
      my1 = 1.0-imy1;
      for (yy=-r;yy<=r;yy++) for (xx=-r;xx<=r;xx++) {
	 psf[img][yy][xx] = 
	    ( nircampsflib[i][j][y1][x1][y2][x2][yy][xx]*mx2*my2+nircampsflib[i][j][y1][x1][y2][x2+1][yy][xx]*imx2*my2+nircampsflib[i][j][y1][x1][y2+1][x2][yy][xx]*mx2*imy2+nircampsflib[i][j][y1][x1][y2+1][x2+1][yy][xx]*imx2*imy2 ) * mx1*my1 +
	    ( nircampsflib[i][j][y1+1][x1][y2][x2][yy][xx]*mx2*my2+nircampsflib[i][j][y1+1][x1][y2][x2+1][yy][xx]*imx2*my2+nircampsflib[i][j][y1+1][x1][y2+1][x2][yy][xx]*mx2*imy2+nircampsflib[i][j][y1+1][x1][y2+1][x2+1][yy][xx]*imx2*imy2 ) * mx1*imy1 +
	    ( nircampsflib[i][j][y1][x1+1][y2][x2][yy][xx]*mx2*my2+nircampsflib[i][j][y1][x1+1][y2][x2+1][yy][xx]*imx2*my2+nircampsflib[i][j][y1][x1+1][y2+1][x2][yy][xx]*mx2*imy2+nircampsflib[i][j][y1][x1+1][y2+1][x2+1][yy][xx]*imx2*imy2 ) * imx1*my1 +
	    ( nircampsflib[i][j][y1+1][x1+1][y2][x2][yy][xx]*mx2*my2+nircampsflib[i][j][y1+1][x1+1][y2][x2+1][yy][xx]*imx2*my2+nircampsflib[i][j][y1+1][x1+1][y2+1][x2][yy][xx]*mx2*imy2+nircampsflib[i][j][y1+1][x1+1][y2+1][x2+1][yy][xx]*imx2*imy2 ) * imx1*imy1;
      }
   }
   else {
      if (img==Nimg && GetGlobalInt(DRIZZLE_BASE)) {
	 y1=(nircam_nypsfpos-1)/2;
	 x1=(nircam_nxpsfpos-1)/2;
      }
      else {
	 y1=(int)(y+256)/512; if (y1<0) y1=0; if (y1>=nircam_nypsfpos) y1=nircam_nypsfpos-1;
	 x1=(int)(x+256)/512; if (x1<0) x1=0; if (x1>=nircam_nxpsfpos) x1=nircam_nxpsfpos-1;
      }
      for (yy=-r;yy<=r;yy++) for (xx=-r;xx<=r;xx++) psf[img][yy][xx]=nircampsflib[i][j][y1][x1][y2][x2][yy][xx]*mx2*my2+nircampsflib[i][j][y1][x1][y2][x2+1][yy][xx]*imx2*my2+nircampsflib[i][j][y1][x1][y2+1][x2][yy][xx]*mx2*imy2+nircampsflib[i][j][y1][x1][y2+1][x2+1][yy][xx]*imx2*imy2;
   }
#ifdef DEBUG_PSF
   printf("y1=%d, my1=%f; x1=%d, mx1=%f\n",y1,my1,x1,mx1);
   printf("y2=%d, my2=%f; x2=%d, mx2=%f\n",y2,my2,x2,mx2);
   for (yy=6;yy>=-6;yy--) if (yy>=-r && yy<=r) {for (xx=-6;xx<=6;xx++) if (xx>=-r && xx<=r) printf("%5d ",(int)(psf[img][yy][xx]*100000+0.5)); printf("\n");}
   fflush(stdout);
#endif
   return 1;
}

#ifdef DEBUG_PSF
void NIRCAMdumpPSFs(void) {
   int img,xphase,yphase,x,y;
   for (img=0;img<Nimg;img++) if (hstmode[img].inst==NIRCAM) {
      for (xphase=-5;xphase<=5;xphase++) calcnircampsf(img,1920.5+0.1*xphase,896.5,RPSF[img],1);
      for (yphase=-5;yphase<=5;yphase++) calcnircampsf(img,1920.5,896.5+0.1*yphase,RPSF[img],1);
      for (x=0;x<=2048;x+=64) calcnircampsf(img,0.5+x,896.5,RPSF[img],1);
      for (y=0;y<=2048;y+=64) calcnircampsf(img,1920.5,0.5+y,RPSF[img],1);
   }
}
#endif

double NIRCAMcalcmag(int img,float x0,float y0,float ct0) {
   double m;

   if (hstmode[img].inst!=NIRCAM) {
      printf("Stupid error; called nircamcalcmag for non-NIRCAM data\n");
      exit(-1);
   }
   if (NIRCAM_NFILTERS<0) NIRCAMinitfilters();
   if (GetParamInt(NIRCAMvega)) m=-2.5*log10(ct0*apcor[img]/iEXP[img]*nircam_ctmult)+NIRCAMfilters[hstmode[img].filt].zp[hstmode[img].cm]+hstmode[img].data1;
   else m=-2.5*log10(ct0*apcor[img]/iEXP[img]*nircam_ctmult)+NIRCAMfilters[hstmode[img].filt].zpJy+hstmode[img].data1+8.9;
   return m;
}

void NIRCAMoutstarinfo(FILE *f,int*ct) {
   int i,j,n;
   for (i=0;i<NIRCAM_NFILTERS;i++) {
      n=0;
      for (j=0;j<Nimg;j++) if (hstmode[j].inst==NIRCAM && hstmode[j].filt==i) n++;
      if (n>1) {
	 fprintf(f,"%d. Total counts, NIRCAM_%s\n",++(*ct),NIRCAMfilters[i].name);
	 fprintf(f,"%d. Total sky level, NIRCAM_%s\n",++(*ct),NIRCAMfilters[i].name);
	 fprintf(f,"%d. Normalized count rate, NIRCAM_%s\n",++(*ct),NIRCAMfilters[i].name);
	 fprintf(f,"%d. Normalized count rate uncertainty, NIRCAM_%s\n",++(*ct),NIRCAMfilters[i].name);
	 if (GetParamInt(NIRCAMvega)) fprintf(f,"%d. Instrumental VEGAMAG magnitude, NIRCAM_%s\n",++(*ct),NIRCAMfilters[i].name);
	 else fprintf(f,"%d. Instrumental ABMAG magnitude, NIRCAM_%s\n",++(*ct),NIRCAMfilters[i].name);
	 fprintf(f,"%d. Transformed UBVRI magnitude, NIRCAM_%s\n",++(*ct),NIRCAMfilters[i].name);
	 fprintf(f,"%d. Magnitude uncertainty, NIRCAM_%s\n",++(*ct),NIRCAMfilters[i].name);
	 fprintf(f,"%d. Chi, NIRCAM_%s\n",++(*ct),NIRCAMfilters[i].name);
	 fprintf(f,"%d. Signal-to-noise, NIRCAM_%s\n",++(*ct),NIRCAMfilters[i].name);
	 fprintf(f,"%d. Sharpness, NIRCAM_%s\n",++(*ct),NIRCAMfilters[i].name);
	 fprintf(f,"%d. Roundness, NIRCAM_%s\n",++(*ct),NIRCAMfilters[i].name);
	 fprintf(f,"%d. Crowding, NIRCAM_%s\n",++(*ct),NIRCAMfilters[i].name);
	 fprintf(f,"%d. Photometry quality flag, NIRCAM_%s\n",++(*ct),NIRCAMfilters[i].name);
      }
   }
}

// Not parallel-safe, not called during threaded processing
static double*smag=NULL,*vmag=NULL,*dvmag=NULL;
void NIRCAMoutstar(FILE *of,float x0,float y0,photdatatype*pdata) {
   int i,j;
   static int *fused=NULL;
   static photdatatype*fphot=NULL;

   if (NIRCAM_NFILTERS<0) NIRCAMinitfilters();
   if (!fphot) {
      fused=(int*)calloc(sizeof(int),NIRCAM_NFILTERS);
      fphot=(photdatatype*)calloc(sizeof(photdatatype),NIRCAM_NFILTERS);
      smag=(double*)calloc(sizeof(double),NIRCAM_NFILTERS);
      vmag=(double*)calloc(sizeof(double),NIRCAM_NFILTERS);
      dvmag=(double*)calloc(sizeof(double),NIRCAM_NFILTERS);
      if (!fused || !fphot || !smag || !vmag || !dvmag) merr();
   }
   for (j=0;j<Nimg;j++) if (hstmode[j].inst==NIRCAM) {
      double dm;
      if (GetParamInt(NIRCAMvega)) dm = -2.5*log10(nircam_ctmult) + NIRCAMfilters[hstmode[j].filt].zp[hstmode[j].cm] - GetParamDouble(Zero) + hstmode[j].data1;
      else dm = -2.5*log10(nircam_ctmult) + NIRCAMfilters[hstmode[j].filt].zpJy - GetParamDouble(Zero) + hstmode[j].data1;
      if (pdata[j].ct>0) {
	 pdata[j].m += dm;
	 if (!GetParamInt(NIRCAMvega)) pdata[j].m += 8.9;
      }
      pdata[j].ctcorr *= pow(10,-0.4*dm);
      pdata[j].dctcorr *= pow(10,-0.4*dm);
   }
   for (i=0;i<NIRCAM_NFILTERS;i++) {
      double wt,cwt,swt,twt=0.,tcwt=0.,tswt=0.,is,iss,tcm=0.;
      fphot[i].ct0=fphot[i].ct=fphot[i].chi=fphot[i].sh=fphot[i].sky=fphot[i].ctcorr=fphot[i].dctcorr=fphot[i].rnd=fphot[i].crowd=0.;
      fused[i]=0;
      fphot[i].flag=0;
      for (j=0;j<Nimg;j++) if (hstmode[j].inst==NIRCAM && hstmode[j].filt==i) {
	 fused[i]++;
	 if (pdata[j].flag<8 && !(pdata[j].flag&GetParamInt(FlagMask))) {
	    is=pdata[j].ct/iEXP[j];
	    iss=pdata[j].dct/iEXP[j];
	    wt=1./iss/iss;
	    cwt=1./pdata[j].dctcorr/pdata[j].dctcorr; // AEDDEBUG new
	    if (GetParamInt(CombineChi) && pdata[j].chi>1) {
	       wt/=pdata[j].chi*pdata[j].chi;
	       cwt/=pdata[j].chi*pdata[j].chi; // AEDDEBUG new
	    }
	    if (is>0) swt=wt*is;
	    else swt=0.0;
	    twt+=wt;
	    tcwt+=cwt; // AEDDEBUG new
	    tswt+=swt;
	    fphot[i].ct0+=pdata[j].ct0/iEXP[j]*wt;
	    fphot[i].ct+=is*wt;
	    fphot[i].chi+=pdata[j].chi*pdata[j].chi*cwt; // AEDDEBUG was wt
	    fphot[i].sh+=pdata[j].sh*swt;
	    fphot[i].sky+=pdata[j].sky/iEXP[j]*wt;
	    fphot[i].ctcorr+=pdata[j].ctcorr*cwt; // AEDDEBUG was wt
	    //fphot[i].dctcorr+=pdata[j].dctcorr*pdata[j].dctcorr*wt*wt;
	    fphot[i].rnd+=pdata[j].rnd*swt; // AEDDEBUG was wt
	    fphot[i].crowd+=pdata[j].crowd*swt;
	    fphot[i].flag|=pdata[j].flag;
	 }
	 tcm+=iEXP[j];
      }
      if (twt>0.) {
	 fphot[i].ct0/=twt/tcm;
	 fphot[i].ct/=twt/tcm;
	 fphot[i].dct=tcm/sqrt(twt);
	 //fphot[i].chi=sqrt(fphot[i].chi/twt);
	 fphot[i].sky/=twt/tcm;
	 //fphot[i].ctcorr/=twt;
	 //fphot[i].dctcorr=sqrt(fphot[i].dctcorr)/twt;
	 //if (fphot[i].ctcorr>0) fphot[i].m=-2.5*log10(fphot[i].ctcorr);
	 //else fphot[i].m=99.999;
	 //if (fphot[i].ct>0) fphot[i].dm=1.0857362*fphot[i].dct/fphot[i].ct;
      }
      if (tcwt>0.) { // AEDDEBUG new
	 fphot[i].chi=sqrt(fphot[i].chi/tcwt); // AEDDEBUG new
	 fphot[i].ctcorr/=tcwt;
	 fphot[i].dctcorr=1./sqrt(tcwt);
	 if (fphot[i].ctcorr>0) {
	    fphot[i].m=-2.5*log10(fphot[i].ctcorr);
	    if (!GetParamInt(NIRCAMvega)) fphot[i].m += 8.9;
	    fphot[i].dm=1.0857362*fphot[i].dctcorr/fphot[i].ctcorr;
	 }
	 else {
	    fphot[i].m=99.999;
	    fphot[i].dm=9.999;
	 }
      }
      else {
	 fphot[i].dct=9999;
	 fphot[i].dctcorr=9999;
	 fphot[i].m=99.999;
	 fphot[i].dm=9.999;
      }
      if (tswt>0.) {
	 fphot[i].sh/=tswt;
	 fphot[i].rnd/=tswt;
	 fphot[i].crowd/=tswt; // AEDDEBUG was twt
      }
      vmag[i]=fphot[i].m;
      dvmag[i]=fphot[i].dm;
   }
   NIRCAMtransform(vmag,dvmag,smag);
   for (i=0;i<NIRCAM_NFILTERS;i++) if (fused[i]>1) {
      if (fphot[i].ct<999999.5) fprintf(of,"  %8.1f",fphot[i].ct);
      else fprintf(of,"  %8.2e",fphot[i].ct);
      if (fphot[i].sky<99999.95) fprintf(of," %8.2f",fphot[i].sky);
      else if (fphot[i].sky<999999.5) fprintf(of," %8.1f",fphot[i].sky);
      else fprintf(of," %8.1e",fphot[i].sky);

      if (fphot[i].ctcorr<0.0) fprintf(of," %8.1e",fphot[i].ctcorr);
      else if (fphot[i].ctcorr<0.99) fprintf(of," %8.2e",fphot[i].ctcorr);
      else if (fphot[i].ctcorr<9.999995) fprintf(of," %8.6f",fphot[i].ctcorr);
      else if (fphot[i].ctcorr<99.99995) fprintf(of," %8.5f",fphot[i].ctcorr);
      else if (fphot[i].ctcorr<999.9995) fprintf(of," %8.4f",fphot[i].ctcorr);
      else if (fphot[i].ctcorr<9999.995) fprintf(of," %8.3f",fphot[i].ctcorr);
      else if (fphot[i].ctcorr<99999.95) fprintf(of," %8.2f",fphot[i].ctcorr);
      else if (fphot[i].ctcorr<999999.5) fprintf(of," %8.1f",fphot[i].ctcorr);
      else fprintf(of," %8.1e",fphot[i].ctcorr);

      if (fphot[i].dctcorr<0.0) fprintf(of," %8.1e",fphot[i].dctcorr);
      else if (fphot[i].dctcorr<0.99) fprintf(of," %8.2e",fphot[i].dctcorr);
      else if (fphot[i].dctcorr<9.999995) fprintf(of," %8.6f",fphot[i].dctcorr);
      else if (fphot[i].dctcorr<99.99995) fprintf(of," %8.5f",fphot[i].dctcorr);
      else if (fphot[i].dctcorr<999.9995) fprintf(of," %8.4f",fphot[i].dctcorr);
      else if (fphot[i].dctcorr<9999.995) fprintf(of," %8.3f",fphot[i].dctcorr);
      else if (fphot[i].dctcorr<99999.95) fprintf(of," %8.2f",fphot[i].dctcorr);
      else if (fphot[i].dctcorr<999999.5) fprintf(of," %8.1f",fphot[i].dctcorr);
      else fprintf(of," %8.1e",fphot[i].dctcorr);

      fprintf(of," %6.3f %6.3f",fphot[i].m,smag[i]);
      if (fphot[i].dm>9.999) fprintf(of," 9.999");
      else fprintf(of," %5.3f",fphot[i].dm);
      fprintf(of," %6.2f %7.1f %6.3f %6.3f %5.3f %2d",fphot[i].chi,fphot[i].ctcorr/fphot[i].dctcorr,fphot[i].sh,fphot[i].rnd,fphot[i].crowd,fphot[i].flag);
   }
}

void NIRCAMoutstarimg(int img,FILE *of,float x0,float y0,photdatatype*pdata) {
   float x;
   if (hstmode[img].inst!=NIRCAM) {
      printf("Stupid error; called outstarimg for non-NIRCAM data\n");
      exit(-1);
   }
   if (pdata[img].ctcorr<=0) x=pdata[img].m;
   else if (smag[hstmode[img].filt]>99) x=smag[hstmode[img].filt];
   else x=pdata[img].m+smag[hstmode[img].filt]-vmag[hstmode[img].filt];
   fprintf(of," %6.3f %6.3f",pdata[img].m,x);
   if (pdata[img].dm>9.999) fprintf(of," 9.999");
   else fprintf(of," %5.3f",pdata[img].dm);
   return;
}

float nircam_apsize(int img,float x,float y) {
   if (hstmode[img].inst!=NIRCAM) {
      printf("Stupid error; called nircam_apsize for non-NIRCAM data\n");
      exit(-1);
   }
   return 10.;
}

void NIRCAMshift(int img,double*x,double*y) {
   if (hstmode[img].inst!=NIRCAM) {
      printf("Stupid error; called nircamshift for non-NIRCAM data\n");
      exit(-1);
   }
   return;
}

void NIRCAMunshift(int img,double*x,double*y) {
   if (hstmode[img].inst!=NIRCAM) {
      printf("Stupid error; called nircamunshift for non-NIRCAM data\n");
      exit(-1);
   }
   return;
}

void writenircaminfo(void) {
   int img;
   fprintf(finfo,"* NIRCAM-specific info\n");
   for (img=0;img<Nimg;img++) if (hstmode[img].inst==NIRCAM) {
      fprintf(finfo,"* image %d: %s 0 %f\n",img+1,NIRCAMfilters[hstmode[img].filt].name,iEXP[img]);
   }
   return;
}

static int*ffused=NULL;
static double*fakem0;
void NIRCAMreadfakemag(FILE*f) {
   int i,img;

   if (NIRCAM_NFILTERS<0) NIRCAMinitfilters();
   if (ffused==NULL) {
      ffused=(int*)calloc(sizeof(int),NIRCAM_NFILTERS);
      fakem0=(double*)calloc(sizeof(double),NIRCAM_NFILTERS);
      if (!ffused || !fakem0) merr();
      for (img=0;img<Nimg;img++) if (hstmode[img].inst==NIRCAM) ffused[hstmode[img].filt]++;
   }
   for (i=0;i<NIRCAM_NFILTERS;i++) if (ffused[i]) fscanf(f,"%lf",fakem0+i);
   return;
}

void NIRCAMfixfakemag(int img,float x0,float y0,double*ct0) {
   int i;
   double dm;

   if (hstmode[img].inst!=NIRCAM) {
      printf("Stupid error; called nircamfixfakemag for non-NIRCAM data\n");
      exit(-1);
   }
   dm=NIRCAMcalcmag(img,x0,y0,1.0)-fakem0[hstmode[img].filt];
   ct0[img]=pow(10,0.4*dm);
   for (i=0;i<5;i++) {
      dm=NIRCAMcalcmag(img,x0,y0,ct0[img])-fakem0[hstmode[img].filt];
      ct0[img]*=pow(10,0.4*dm);
   }
   return;
}

char *NIRCAMimagestring(int img) {
   if (hstmode[img].inst!=NIRCAM) {
      printf("Stupid error; called nircamimagestring for non-NIRCAM data\n");
      exit(-1);
   }
   return NIRCAMfilters[hstmode[img].filt].name;
}
