#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <math.h>

#include "nircamfilters.h"
/*
typedef struct {
   char name[11],color;
   double zp[10];
} NIRCAMfilttype;
*/

int NIRCAM_NFILTERS=-1;
NIRCAMfilttype *NIRCAMfilters;

static void readdata(void) {
   int i,j;
   FILE *f;
   char str[1025];
   double eecorr;

   sprintf(str,"%s/nircam/data/filters.dat",BASEDIR);
   if ((f=fopen(str,"r"))==NULL) {
      printf("Could not find %s\n",str);
      exit(0);
   }
   fscanf(f,"%d",&NIRCAM_NFILTERS);
   fgets(str,81,f);
   NIRCAMfilters=(NIRCAMfilttype*)calloc(sizeof(NIRCAMfilttype),NIRCAM_NFILTERS);
   assert(NIRCAMfilters!=NULL);
   for (i=0;i<NIRCAM_NFILTERS;i++) {
      fgets(NIRCAMfilters[i].name,11,f); NIRCAMfilters[i].name[strlen(NIRCAMfilters[i].name)-1]=0;
      NIRCAMfilters[i].color=fgetc(f);
      fgets(str,81,f);
      for (j=0;j<10;j++) fscanf(f,"%lf",NIRCAMfilters[i].zp+j);
      fscanf(f,"%lf",&eecorr);
      fgets(str,81,f);
      //applying encircled energy correction afterwards since .xform is differential;
      for (j=0;j<10;j++) NIRCAMfilters[i].zp[j] -= eecorr;
      NIRCAMfilters[i].zpJy = -eecorr;
   }
   fclose(f);
   return;
}

int NIRCAMfindfilt(char*str) {
   int i;
   void NIRCAMinitfilters();
   if (NIRCAM_NFILTERS<0) NIRCAMinitfilters();
   for (i=0;i<NIRCAM_NFILTERS;i++) if (!strcmp(NIRCAMfilters[i].name,str)) return i;
   printf("Illegal filter %s\n",str);
   exit(0);
   return -1;
}

void NIRCAMinitfilters(void) {
   readdata();
   return;
}

void NIRCAMtransform(double vmag[],double dvmag[],double smag[]) {
   int f;
   if (NIRCAM_NFILTERS<0) NIRCAMinitfilters();
   for (f=0;f<NIRCAM_NFILTERS;f++) smag[f]=99.999;
}

double NIRCAMuntransform(int filt,double smag[5]) {
   return 99999.;
}
