#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <fits.h>
#include "../dolphot_defs.h"
#include "miripsfdata.h"
#include "mirifilters.h"
#include "miridistort.h"

extern void shift(int img,double x0,double y0,double *x,double *y,int dir);

static float*******miripsflib=NULL;
static int MIRI_RPSF=24;
static int ANY_MIRI=0;

void miriinitparam(void) {
   char str[161],*ptr;
   int img;
   ANY_MIRI=0;
   for (img=0;img<Timg && !ANY_MIRI;img++) {
      strcpy(str,getcardval(dataim+img,"DOL_MIRI",0));
      strtol(str,&ptr,10);
      if (ptr!=str) ANY_MIRI=1;
   }
   if (ANY_MIRI==0) return;
   ZeroCameraPars();
   return;
}

#define SetGlobal(x,y) GLOBAL_DONOTREFERENCE.x=y
void miriinitpsf(void) {
   int img,i,j,y1,x1,y2,x2,y3,n2,n3,n3skip;
   char str[161],*ptr;
   FILE *f;
   float***** ptr1;
   float**** ptr2;
   float*** ptr3;
   float** ptr4;
   float* ptr5;

   if (MIRI_NFILTERS<0) MIRIinitfilters();
   if (miripsflib==NULL) {
      miripsflib=(float*******)calloc(sizeof(float******),MIRI_NFILTERS);
      if (!miripsflib) merr();
   }
   for (j=0;j<MIRI_NFILTERS;j++) miripsflib[j]=NULL;
   for (img=0;img<Timg;img++) {
      strcpy(str,getcardval(dataim+img,"DOL_MIRI",0));
      int cm=strtol(str,&ptr,10);
      if (str[0]==0) {
	 // AEDDEBUG need warning: printf("**Image %d has not been preprocessed with mirimask; cannot proceed\n",img+1);
      }
      else {
	 if (cm<-1 || cm>0) {
	    printf("**Image %d's chip cannot be identified; please report bug.\n",img+1);
	    exit(-1);
	 }
	 hstmode[img].inst=MIRI;
	 hstmode[img].cm=cm;
	 if (img==Nimg) {
	    if (hstmode[img].cm==-1) {
	       hstmode[img].cm=0;
	       SetGlobal(DRIZZLE_BASE,1);
	    }
	    else SetGlobal(DRIZZLE_BASE,0);
	 }
	 if (hstmode[img].cm<0) {
	    printf("**Image %d has been drizzled; cannot run photometry\n",img+1);
	    exit(-1);
	 }
	 hstmode[img].data1 = atof(getcardval(dataim+img,"DOL_C2JY",1));
	 strcpy(str,getcardval(datahd+img,"FILTER",0));
	 hstmode[img].filt=MIRIfindfilt(str);
	 //printf("Image %d: filt=%d (%s)\n",img+1,hstmode[img].filt,MIRIfilters[hstmode[img].filt].name);
	 if (RPSF[img]>=miri_rpsf) {RPSF[img]=miri_rpsf-1; printf("Lowering RPSF to %d\n",RPSF[img]);}
	 if (RAper[img]>miri_rpsf-1.) {RAper[img]=miri_rpsf-1; printf("Lowering RAper to %g\n",RAper[img]);}
      }
   }
   MIRI_RPSF=0;
   for (img=0;img<Timg;img++) if (hstmode[img].inst==MIRI) {
      apsf[img][0][0]=1.;
      apsf[img][1][0]=1.;
      apsf[img][2][0]=0.;
      apsize[img]=15.;
      for (i=1;i<5;i++) apsf[img][0][i]=apsf[img][1][i]=apsf[img][2][i]=0.;
      if (MIRI_RPSF<RPSF[img]) MIRI_RPSF=RPSF[img];
      if (MIRI_RPSF<rphot[img]) MIRI_RPSF=rphot[img];
   }
   for (img=0;img<Timg;img++) if (hstmode[img].inst==MIRI && miripsflib[j=hstmode[img].filt]==NULL) {
      sprintf(str,"%s/miri/data/%s.psf",BASEDIR,MIRIfilters[hstmode[img].filt].name);
      if ((f=fopen(str,"rb"))==NULL) {
	 printf("Cannot open %s\n",str);
	 exit(-1);
      }
      n2=2*miri_n2psf+1;
      n3=2*MIRI_RPSF+1;
      n3skip=miri_rpsf-MIRI_RPSF;
      miripsflib[j]=(float******)calloc(sizeof(float*****),miri_nypsfpos);
      ptr1=(float*****)calloc(sizeof(float****),miri_nypsfpos*miri_nxpsfpos);
      ptr2=(float****)calloc(sizeof(float***),miri_nypsfpos*miri_nxpsfpos*n2);
      ptr3=(float***)calloc(sizeof(float**),miri_nypsfpos*miri_nxpsfpos*n2*n2);
      ptr4=(float**)calloc(sizeof(float*),miri_nypsfpos*miri_nxpsfpos*n2*n2*n3);
      ptr5=(float*)calloc(sizeof(float),miri_nypsfpos*miri_nxpsfpos*n2*n2*n3*n3);
      if (!miripsflib[j] || !ptr1) merr();
      for (y1=0;y1<miri_nypsfpos;y1++) {
	 miripsflib[j][y1]=ptr1;
	 ptr1+=miri_nxpsfpos;
	 for (x1=0;x1<miri_nxpsfpos;x1++) {
	    miripsflib[j][y1][x1]=ptr2+miri_n2psf;
	    ptr2+=n2;
	    for (y2=-miri_n2psf;y2<=miri_n2psf;y2++) {
	       miripsflib[j][y1][x1][y2]=ptr3+miri_n2psf;
	       ptr3+=n2;
	       for (x2=-miri_n2psf;x2<=miri_n2psf;x2++) {
		  miripsflib[j][y1][x1][y2][x2]=ptr4+MIRI_RPSF;
		  ptr4+=n3;
		  if (n3skip) fseek(f,4*n3skip*(2*miri_rpsf+1),SEEK_CUR);
		  for (y3=-MIRI_RPSF;y3<=MIRI_RPSF;y3++) {
		     miripsflib[j][y1][x1][y2][x2][y3]=ptr5+MIRI_RPSF;
		     ptr5+=n3;
		     if (n3skip) fseek(f,4*n3skip,SEEK_CUR);
		     ffread(miripsflib[j][y1][x1][y2][x2][y3]-MIRI_RPSF,4,n3,f);
		     if (n3skip) fseek(f,4*n3skip,SEEK_CUR);
		  }
		  if (n3skip) fseek(f,4*n3skip*(2*miri_rpsf+1),SEEK_CUR);
	       }
	    }
	 }
      }
      fclose(f);
   }
   return;
}
#undef SetGlobal

void mirifreepsf(void) {
   int j;
   for (j=0;j<MIRI_NFILTERS;j++) if (miripsflib[j]) {
      free(miripsflib[j][0][0][-miri_n2psf][-miri_n2psf][-MIRI_RPSF]-MIRI_RPSF);
      free(miripsflib[j][0][0][-miri_n2psf][-miri_n2psf]-MIRI_RPSF);
      free(miripsflib[j][0][0][-miri_n2psf]-miri_n2psf);
      free(miripsflib[j][0][0]-miri_n2psf);
      free(miripsflib[j][0]);
      free(miripsflib[j]);
      miripsflib[j]=NULL;
   }
   return;
}

//#define DEBUG_PSF
int calcmiripsf(int img,float x,float y,int r,int force) {
   int i,j,y1,x1,y2,x2,yy,xx;
   float mx1=1,my1=1,imx1=0,imy1=0;
   float mx2,my2,imx2,imy2;
   static int first=1,firstimg[MAXNIMG],lastr[MAXNIMG];
   static float lastx[MAXNIMG],lasty[MAXNIMG];

   if (hstmode[img].inst!=MIRI) {
      printf("Stupid error; called miripsf for non-MIRI data\n");
      exit(-1);
   }
   if (first) {
#ifdef DOLPHOT_THREADED
#pragma omp critical
      if (first) {
#endif
	 for (i=0;i<Timg;i++) firstimg[i]=1;
	 first=0;
#ifdef DOLPHOT_THREADED
      }
#endif
   }
   if (!firstimg[img] && lastpsftype[img]==1 && x==lastx[img] && y==lasty[img] && r<=lastr[img] && !poffreset[img] && !force) return 0;
   firstimg[img]=0;lastpsftype[img]=1;lastx[img]=x;lasty[img]=y;lastr[img]=r;
   j=hstmode[img].filt;
#ifdef DEBUG_PSF
   printf("%d %d %f %f %d",img,j,x,y,r);
   printf("%s PSF at %f,%f; r=%d:\n",MIRIfilters[j].name,x,y,r);
   fflush(stdout);
#endif
   imy2=y-(int)y;
   if (imy2<0) imy2++;
   imy2=(imy2-0.5)*miri_sub;
   y2=(int)(imy2+miri_sub)-miri_sub;
   imy2-=y2; my2=1-imy2;
   imx2=x-(int)x;
   if (imx2<0) imx2++;
   imx2=(imx2-0.5)*miri_sub;
   x2=(int)(imx2+miri_sub)-miri_sub;
   imx2-=x2; mx2=1-imx2;
   if (GetParamInt(InterpPSFlib) && (img<Nimg || !GetGlobalInt(DRIZZLE_BASE))) {
      imx1 = x/256.0;
      imy1 = y/256.0;
      if (imx1<=0.0) {x1=0; imx1=0.0;}
      else if (imx1>=miri_nxpsfpos-1.0) {x1=miri_nxpsfpos-2; imx1=1.0;}
      else {x1=(int)imx1; imx1-=x1;}
      mx1 = 1.0-imx1;
      if (imy1<=0.0) {y1=0; imy1=0.0;}
      else if (imy1>=miri_nypsfpos-1.0) {y1=miri_nypsfpos-2; imy1=1.0;}
      else {y1=(int)imy1; imy1-=y1;}
      my1 = 1.0-imy1;
      for (yy=-r;yy<=r;yy++) for (xx=-r;xx<=r;xx++) {
	 psf[img][yy][xx] = 
	    ( miripsflib[j][y1][x1][y2][x2][yy][xx]*mx2*my2+miripsflib[j][y1][x1][y2][x2+1][yy][xx]*imx2*my2+miripsflib[j][y1][x1][y2+1][x2][yy][xx]*mx2*imy2+miripsflib[j][y1][x1][y2+1][x2+1][yy][xx]*imx2*imy2 ) * mx1*my1 +
	    ( miripsflib[j][y1+1][x1][y2][x2][yy][xx]*mx2*my2+miripsflib[j][y1+1][x1][y2][x2+1][yy][xx]*imx2*my2+miripsflib[j][y1+1][x1][y2+1][x2][yy][xx]*mx2*imy2+miripsflib[j][y1+1][x1][y2+1][x2+1][yy][xx]*imx2*imy2 ) * mx1*imy1 +
	    ( miripsflib[j][y1][x1+1][y2][x2][yy][xx]*mx2*my2+miripsflib[j][y1][x1+1][y2][x2+1][yy][xx]*imx2*my2+miripsflib[j][y1][x1+1][y2+1][x2][yy][xx]*mx2*imy2+miripsflib[j][y1][x1+1][y2+1][x2+1][yy][xx]*imx2*imy2 ) * imx1*my1 +
	    ( miripsflib[j][y1+1][x1+1][y2][x2][yy][xx]*mx2*my2+miripsflib[j][y1+1][x1+1][y2][x2+1][yy][xx]*imx2*my2+miripsflib[j][y1+1][x1+1][y2+1][x2][yy][xx]*mx2*imy2+miripsflib[j][y1+1][x1+1][y2+1][x2+1][yy][xx]*imx2*imy2 ) * imx1*imy1;
      }
   }
   else {
      if (img==Nimg && GetGlobalInt(DRIZZLE_BASE)) {
	 y1=(miri_nypsfpos-1)/2;
	 x1=(miri_nxpsfpos-1)/2;
      }
      else {
	 y1=(int)(y-128)/256; if (y1<0) y1=0; if (y1>=miri_nypsfpos) y1=miri_nypsfpos-1;
	 x1=(int)(x-128)/256; if (x1<0) x1=0; if (x1>=miri_nxpsfpos) x1=miri_nxpsfpos-1;
      }
      for (yy=-r;yy<=r;yy++) for (xx=-r;xx<=r;xx++) psf[img][yy][xx]=miripsflib[j][y1][x1][y2][x2][yy][xx]*mx2*my2+miripsflib[j][y1][x1][y2][x2+1][yy][xx]*imx2*my2+miripsflib[j][y1][x1][y2+1][x2][yy][xx]*mx2*imy2+miripsflib[j][y1][x1][y2+1][x2+1][yy][xx]*imx2*imy2;
   }
#ifdef DEBUG_PSF
   printf("y1=%d, my1=%f; x1=%d, mx1=%f\n",y1,my1,x1,mx1);
   printf("y2=%d, my2=%f; x2=%d, mx2=%f\n",y2,my2,x2,mx2);
   for (yy=6;yy>=-6;yy--) if (yy>=-r && yy<=r) {for (xx=-6;xx<=6;xx++) if (xx>=-r && xx<=r) printf("%5d ",(int)(psf[img][yy][xx]*100000+0.5)); printf("\n");}
   fflush(stdout);
#endif
   return 1;
}

#ifdef DEBUG_PSF
void MIRIdumpPSFs(void) {
   int img,xphase,yphase,x,y;
   for (img=0;img<Nimg;img++) if (hstmode[img].inst==MIRI) {
      for (xphase=-5;xphase<=5;xphase++) calcmiripsf(img,1920.5+0.1*xphase,896.5,RPSF[img],1);
      for (yphase=-5;yphase<=5;yphase++) calcmiripsf(img,1920.5,896.5+0.1*yphase,RPSF[img],1);
      for (x=0;x<=1024;x+=64) calcmiripsf(img,0.5+x,896.5,RPSF[img],1);
      for (y=0;y<=1024;y+=64) calcmiripsf(img,1920.5,0.5+y,RPSF[img],1);
   }
}
#endif

double MIRIcalcmag(int img,float x0,float y0,float ct0) {
   double m;

   if (hstmode[img].inst!=MIRI) {
      printf("Stupid error; called miricalcmag for non-MIRI data\n");
      exit(-1);
   }
   if (MIRI_NFILTERS<0) MIRIinitfilters();
   // -2.5*log10(ct0*apcor[img]/iEXP[img]*miri_ctmult) = units of DN/sec
   // +hstmode[img].data1 = units of Jy
   // +8.9 = units of ABmag
   // +zp = units of Vegamag
   if (GetParamInt(MIRIvega)) m=-2.5*log10(ct0*apcor[img]/iEXP[img]*miri_ctmult)+MIRIfilters[hstmode[img].filt].zp+hstmode[img].data1+8.9;
   else m=-2.5*log10(ct0*apcor[img]/iEXP[img]*miri_ctmult)+MIRIfilters[hstmode[img].filt].zpJy+hstmode[img].data1+8.9;
   return m;
}

void MIRIoutstarinfo(FILE *f,int*ct) {
   int i,j,n;
   for (i=0;i<MIRI_NFILTERS;i++) {
      n=0;
      for (j=0;j<Nimg;j++) if (hstmode[j].inst==MIRI && hstmode[j].filt==i) n++;
      if (n>1) {
	 fprintf(f,"%d. Total counts, MIRI_%s\n",++(*ct),MIRIfilters[i].name);
	 fprintf(f,"%d. Total sky level, MIRI_%s\n",++(*ct),MIRIfilters[i].name);
	 fprintf(f,"%d. Normalized count rate, MIRI_%s\n",++(*ct),MIRIfilters[i].name);
	 fprintf(f,"%d. Normalized count rate uncertainty, MIRI_%s\n",++(*ct),MIRIfilters[i].name);
	 if (GetParamInt(MIRIvega)) fprintf(f,"%d. Instrumental VEGAMAG magnitude, MIRI_%s\n",++(*ct),MIRIfilters[i].name);
	 else fprintf(f,"%d. Instrumental ABMAG magnitude, MIRI_%s\n",++(*ct),MIRIfilters[i].name);
	 fprintf(f,"%d. Transformed UBVRI magnitude, MIRI_%s\n",++(*ct),MIRIfilters[i].name);
	 fprintf(f,"%d. Magnitude uncertainty, MIRI_%s\n",++(*ct),MIRIfilters[i].name);
	 fprintf(f,"%d. Chi, MIRI_%s\n",++(*ct),MIRIfilters[i].name);
	 fprintf(f,"%d. Signal-to-noise, MIRI_%s\n",++(*ct),MIRIfilters[i].name);
	 fprintf(f,"%d. Sharpness, MIRI_%s\n",++(*ct),MIRIfilters[i].name);
	 fprintf(f,"%d. Roundness, MIRI_%s\n",++(*ct),MIRIfilters[i].name);
	 fprintf(f,"%d. Crowding, MIRI_%s\n",++(*ct),MIRIfilters[i].name);
	 fprintf(f,"%d. Photometry quality flag, MIRI_%s\n",++(*ct),MIRIfilters[i].name);
      }
   }
}

// Not parallel-safe, not called during threaded processing
static double*smag=NULL,*vmag=NULL,*dvmag=NULL;
void MIRIoutstar(FILE *of,float x0,float y0,photdatatype*pdata) {
   int i,j;
   static int *fused=NULL;
   static photdatatype*fphot=NULL;

   if (MIRI_NFILTERS<0) MIRIinitfilters();
   if (!fphot) {
      fused=(int*)calloc(sizeof(int),MIRI_NFILTERS);
      fphot=(photdatatype*)calloc(sizeof(photdatatype),MIRI_NFILTERS);
      smag=(double*)calloc(sizeof(double),MIRI_NFILTERS);
      vmag=(double*)calloc(sizeof(double),MIRI_NFILTERS);
      dvmag=(double*)calloc(sizeof(double),MIRI_NFILTERS);
      if (!fused || !fphot || !smag || !vmag || !dvmag) merr();
   }
   for (j=0;j<Nimg;j++) if (hstmode[j].inst==MIRI) {
      double dm;
      if (GetParamInt(MIRIvega)) dm = -2.5*log10(miri_ctmult) + MIRIfilters[hstmode[j].filt].zp - GetParamDouble(Zero) + hstmode[j].data1 + 8.9;
      else dm = -2.5*log10(miri_ctmult) + MIRIfilters[hstmode[j].filt].zpJy - GetParamDouble(Zero) + hstmode[j].data1;
      if (pdata[j].ct>0) {
	 pdata[j].m += dm;
	 if (!GetParamInt(MIRIvega)) pdata[j].m += 8.9;
      }
      pdata[j].ctcorr *= pow(10,-0.4*dm);
      pdata[j].dctcorr *= pow(10,-0.4*dm);
   }
   for (i=0;i<MIRI_NFILTERS;i++) {
      double wt,cwt,swt,twt=0.,tcwt=0.,tswt=0.,is,iss,tcm=0.;
      fphot[i].ct0=fphot[i].ct=fphot[i].chi=fphot[i].sh=fphot[i].sky=fphot[i].ctcorr=fphot[i].dctcorr=fphot[i].rnd=fphot[i].crowd=0.;
      fused[i]=0;
      fphot[i].flag=0;
      for (j=0;j<Nimg;j++) if (hstmode[j].inst==MIRI && hstmode[j].filt==i) {
	 fused[i]++;
	 if (pdata[j].flag<8 && !(pdata[j].flag&GetParamInt(FlagMask))) {
	    is=pdata[j].ct/iEXP[j];
	    iss=pdata[j].dct/iEXP[j];
	    wt=1./iss/iss;
	    cwt=1./pdata[j].dctcorr/pdata[j].dctcorr; // AEDDEBUG new
	    if (GetParamInt(CombineChi) && pdata[j].chi>1) {
	       wt/=pdata[j].chi*pdata[j].chi;
	       cwt/=pdata[j].chi*pdata[j].chi; // AEDDEBUG new
	    }
	    if (is>0) swt=wt*is;
	    else swt=0.0;
	    twt+=wt;
	    tcwt+=cwt; // AEDDEBUG new
	    tswt+=swt;
	    fphot[i].ct0+=pdata[j].ct0/iEXP[j]*wt;
	    fphot[i].ct+=is*wt;
	    fphot[i].chi+=pdata[j].chi*pdata[j].chi*cwt; // AEDDEBUG was wt
	    fphot[i].sh+=pdata[j].sh*swt;
	    fphot[i].sky+=pdata[j].sky/iEXP[j]*wt;
	    fphot[i].ctcorr+=pdata[j].ctcorr*cwt; // AEDDEBUG was wt
	    //fphot[i].dctcorr+=pdata[j].dctcorr*pdata[j].dctcorr*wt*wt;
	    fphot[i].rnd+=pdata[j].rnd*swt; // AEDDEBUG was wt
	    fphot[i].crowd+=pdata[j].crowd*swt;
	    fphot[i].flag|=pdata[j].flag;
	 }
	 tcm+=iEXP[j];
      }
      if (twt>0.) {
	 fphot[i].ct0/=twt/tcm;
	 fphot[i].ct/=twt/tcm;
	 fphot[i].dct=tcm/sqrt(twt);
	 //fphot[i].chi=sqrt(fphot[i].chi/twt);
	 fphot[i].sky/=twt/tcm;
	 //fphot[i].ctcorr/=twt;
	 //fphot[i].dctcorr=sqrt(fphot[i].dctcorr)/twt;
	 //if (fphot[i].ctcorr>0) fphot[i].m=-2.5*log10(fphot[i].ctcorr);
	 //else fphot[i].m=99.999;
	 //if (fphot[i].ct>0) fphot[i].dm=1.0857362*fphot[i].dct/fphot[i].ct;
      }
      if (tcwt>0.) { // AEDDEBUG new
	 fphot[i].chi=sqrt(fphot[i].chi/tcwt); // AEDDEBUG new
	 fphot[i].ctcorr/=tcwt;
	 fphot[i].dctcorr=1./sqrt(tcwt);
	 if (fphot[i].ctcorr>0) {
	    fphot[i].m=-2.5*log10(fphot[i].ctcorr);
	    if (!GetParamInt(MIRIvega)) fphot[i].m += 8.9;
	    fphot[i].dm=1.0857362*fphot[i].dctcorr/fphot[i].ctcorr;
	 }
	 else {
	    fphot[i].m=99.999;
	    fphot[i].dm=9.999;
	 }
      }
      else {
	 fphot[i].dct=9999;
	 fphot[i].dctcorr=9999;
	 fphot[i].m=99.999;
	 fphot[i].dm=9.999;
      }
      if (tswt>0.) {
	 fphot[i].sh/=tswt;
	 fphot[i].rnd/=tswt;
	 fphot[i].crowd/=tswt; // AEDDEBUG was twt
      }
      vmag[i]=fphot[i].m;
      dvmag[i]=fphot[i].dm;
   }
   MIRItransform(vmag,dvmag,smag);
   for (i=0;i<MIRI_NFILTERS;i++) if (fused[i]>1) {
      if (fphot[i].ct<999999.5) fprintf(of,"  %8.1f",fphot[i].ct);
      else fprintf(of,"  %8.2e",fphot[i].ct);
      if (fphot[i].sky<99999.95) fprintf(of," %8.2f",fphot[i].sky);
      else if (fphot[i].sky<999999.5) fprintf(of," %8.1f",fphot[i].sky);
      else fprintf(of," %8.1e",fphot[i].sky);

      if (fphot[i].ctcorr<0.0) fprintf(of," %8.1e",fphot[i].ctcorr);
      else if (fphot[i].ctcorr<0.99) fprintf(of," %8.2e",fphot[i].ctcorr);
      else if (fphot[i].ctcorr<9.999995) fprintf(of," %8.6f",fphot[i].ctcorr);
      else if (fphot[i].ctcorr<99.99995) fprintf(of," %8.5f",fphot[i].ctcorr);
      else if (fphot[i].ctcorr<999.9995) fprintf(of," %8.4f",fphot[i].ctcorr);
      else if (fphot[i].ctcorr<9999.995) fprintf(of," %8.3f",fphot[i].ctcorr);
      else if (fphot[i].ctcorr<99999.95) fprintf(of," %8.2f",fphot[i].ctcorr);
      else if (fphot[i].ctcorr<999999.5) fprintf(of," %8.1f",fphot[i].ctcorr);
      else fprintf(of," %8.1e",fphot[i].ctcorr);

      if (fphot[i].dctcorr<0.0) fprintf(of," %8.1e",fphot[i].dctcorr);
      else if (fphot[i].dctcorr<0.99) fprintf(of," %8.2e",fphot[i].dctcorr);
      else if (fphot[i].dctcorr<9.999995) fprintf(of," %8.6f",fphot[i].dctcorr);
      else if (fphot[i].dctcorr<99.99995) fprintf(of," %8.5f",fphot[i].dctcorr);
      else if (fphot[i].dctcorr<999.9995) fprintf(of," %8.4f",fphot[i].dctcorr);
      else if (fphot[i].dctcorr<9999.995) fprintf(of," %8.3f",fphot[i].dctcorr);
      else if (fphot[i].dctcorr<99999.95) fprintf(of," %8.2f",fphot[i].dctcorr);
      else if (fphot[i].dctcorr<999999.5) fprintf(of," %8.1f",fphot[i].dctcorr);
      else fprintf(of," %8.1e",fphot[i].dctcorr);

      fprintf(of," %6.3f %6.3f",fphot[i].m,smag[i]);
      if (fphot[i].dm>9.999) fprintf(of," 9.999");
      else fprintf(of," %5.3f",fphot[i].dm);
      fprintf(of," %6.2f %7.1f %6.3f %6.3f %5.3f %2d",fphot[i].chi,fphot[i].ctcorr/fphot[i].dctcorr,fphot[i].sh,fphot[i].rnd,fphot[i].crowd,fphot[i].flag);
   }
}

void MIRIoutstarimg(int img,FILE *of,float x0,float y0,photdatatype*pdata) {
   float x;
   if (hstmode[img].inst!=MIRI) {
      printf("Stupid error; called outstarimg for non-MIRI data\n");
      exit(-1);
   }
   if (pdata[img].ctcorr<=0) x=pdata[img].m;
   else if (smag[hstmode[img].filt]>99) x=smag[hstmode[img].filt];
   else x=pdata[img].m+smag[hstmode[img].filt]-vmag[hstmode[img].filt];
   fprintf(of," %6.3f %6.3f",pdata[img].m,x);
   if (pdata[img].dm>9.999) fprintf(of," 9.999");
   else fprintf(of," %5.3f",pdata[img].dm);
   return;
}

float miri_apsize(int img,float x,float y) {
   if (hstmode[img].inst!=MIRI) {
      printf("Stupid error; called miri_apsize for non-MIRI data\n");
      exit(-1);
   }
   return 15.;
}

void MIRIshift(int img,double*x,double*y) {
   if (hstmode[img].inst!=MIRI) {
      printf("Stupid error; called mirishift for non-MIRI data\n");
      exit(-1);
   }
   return;
}

void MIRIunshift(int img,double*x,double*y) {
   if (hstmode[img].inst!=MIRI) {
      printf("Stupid error; called miriunshift for non-MIRI data\n");
      exit(-1);
   }
   return;
}

void writemiriinfo(void) {
   int img;
   fprintf(finfo,"* MIRI-specific info\n");
   for (img=0;img<Nimg;img++) if (hstmode[img].inst==MIRI) {
      fprintf(finfo,"* image %d: %s 0 %f\n",img+1,MIRIfilters[hstmode[img].filt].name,iEXP[img]);
   }
   return;
}

static int*ffused=NULL;
static double*fakem0;
void MIRIreadfakemag(FILE*f) {
   int i,img;

   if (MIRI_NFILTERS<0) MIRIinitfilters();
   if (ffused==NULL) {
      ffused=(int*)calloc(sizeof(int),MIRI_NFILTERS);
      fakem0=(double*)calloc(sizeof(double),MIRI_NFILTERS);
      if (!ffused || !fakem0) merr();
      for (img=0;img<Nimg;img++) if (hstmode[img].inst==MIRI) ffused[hstmode[img].filt]++;
   }
   for (i=0;i<MIRI_NFILTERS;i++) if (ffused[i]) fscanf(f,"%lf",fakem0+i);
   return;
}

void MIRIfixfakemag(int img,float x0,float y0,double*ct0) {
   int i;
   double dm;

   if (hstmode[img].inst!=MIRI) {
      printf("Stupid error; called mirifixfakemag for non-MIRI data\n");
      exit(-1);
   }
   dm=MIRIcalcmag(img,x0,y0,1.0)-fakem0[hstmode[img].filt];
   ct0[img]=pow(10,0.4*dm);
   for (i=0;i<5;i++) {
      dm=MIRIcalcmag(img,x0,y0,ct0[img])-fakem0[hstmode[img].filt];
      ct0[img]*=pow(10,0.4*dm);
   }
   return;
}

char *MIRIimagestring(int img) {
   if (hstmode[img].inst!=MIRI) {
      printf("Stupid error; called miriimagestring for non-MIRI data\n");
      exit(-1);
   }
   return MIRIfilters[hstmode[img].filt].name;
}
