#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <math.h>

#include "mirifilters.h"

int MIRI_NFILTERS=-1;
MIRIfilttype *MIRIfilters;

static void readdata(void) {
   int i;
   FILE *f;
   char str[1025];
   double eecorr;

   sprintf(str,"%s/miri/data/filters.dat",BASEDIR);
   if ((f=fopen(str,"r"))==NULL) {
      printf("Could not find %s\n",str);
      exit(0);
   }
   fscanf(f,"%d",&MIRI_NFILTERS);
   fgets(str,81,f);
   MIRIfilters=(MIRIfilttype*)calloc(sizeof(MIRIfilttype),MIRI_NFILTERS);
   assert(MIRIfilters!=NULL);
   for (i=0;i<MIRI_NFILTERS;i++) {
      fgets(MIRIfilters[i].name,11,f); MIRIfilters[i].name[strlen(MIRIfilters[i].name)-1]=0;
      MIRIfilters[i].color=fgetc(f);
      fgets(str,81,f);
      fscanf(f,"%lf %lf",&MIRIfilters[i].zp,&eecorr);
      fgets(str,81,f);
      //applying encircled energy correction afterwards since .xform is differential;
      MIRIfilters[i].zp -= eecorr;
      MIRIfilters[i].zpJy = -eecorr;
   }
   fclose(f);
   return;
}

int MIRIfindfilt(char*str) {
   int i;
   void MIRIinitfilters();
   if (MIRI_NFILTERS<0) MIRIinitfilters();
   for (i=0;i<MIRI_NFILTERS;i++) if (!strcmp(MIRIfilters[i].name,str)) return i;
   printf("Illegal filter %s\n",str);
   exit(0);
   return -1;
}

void MIRIinitfilters(void) {
   readdata();
   return;
}

void MIRItransform(double vmag[],double dvmag[],double smag[]) {
   int f;
   if (MIRI_NFILTERS<0) MIRIinitfilters();
   for (f=0;f<MIRI_NFILTERS;f++) smag[f]=99.999;
}

double MIRIuntransform(int filt,double smag[5]) {
   return 99999.;
}
